/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.hosted.c.GraalAccess;
import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class SubstitutionField
implements ReadableJavaField {
    private final ResolvedJavaField original;
    private final ResolvedJavaField annotated;

    public SubstitutionField(ResolvedJavaField original, ResolvedJavaField annotated) {
        this.original = original;
        this.annotated = annotated;
    }

    @Override
    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return false;
    }

    @Override
    public JavaConstant readValue(JavaConstant receiver) {
        JavaConstant value = ReadableJavaField.readFieldValue(GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
        if (value == null) {
            value = ReadableJavaField.readFieldValue(GraalAccess.getOriginalProviders().getConstantReflection(), this.annotated, receiver);
        }
        return value;
    }

    public int getModifiers() {
        return this.annotated.getModifiers();
    }

    public int getOffset() {
        return this.annotated.getOffset();
    }

    public boolean isInternal() {
        return this.annotated.isInternal();
    }

    public boolean isSynthetic() {
        return this.annotated.isSynthetic();
    }

    public String getName() {
        return this.annotated.getName();
    }

    public JavaType getType() {
        return this.annotated.getType();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.annotated.getDeclaringClass();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotated.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.annotated.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotated.getDeclaredAnnotations();
    }
}

