/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.util.VMError;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;

public class SubstitutionMethod
implements ResolvedJavaMethod,
GraphProvider {
    private final ResolvedJavaMethod original;
    private final ResolvedJavaMethod annotated;
    private final LocalVariableTable localVariableTable;
    private final boolean inClassSubstitution;

    public SubstitutionMethod(ResolvedJavaMethod original, ResolvedJavaMethod annotated) {
        this(original, annotated, false);
    }

    public SubstitutionMethod(ResolvedJavaMethod original, ResolvedJavaMethod annotated, boolean inClassSubstitution) {
        this.original = original;
        this.annotated = annotated;
        this.inClassSubstitution = inClassSubstitution;
        LocalVariableTable newLocalVariableTable = null;
        if (annotated.getLocalVariableTable() != null) {
            Local[] origLocals = annotated.getLocalVariableTable().getLocals();
            Local[] newLocals = new Local[origLocals.length];
            ResolvedJavaType accessingClass = annotated.getDeclaringClass();
            for (int i = 0; i < newLocals.length; ++i) {
                Local origLocal = origLocals[i];
                newLocals[i] = new Local(origLocal.getName(), (JavaType)origLocal.getType().resolve(accessingClass), origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
            }
            newLocalVariableTable = new LocalVariableTable(newLocals);
        }
        this.localVariableTable = newLocalVariableTable;
    }

    public ResolvedJavaMethod getOriginal() {
        return this.original;
    }

    public ResolvedJavaMethod getAnnotated() {
        return this.annotated;
    }

    public String getName() {
        return this.original.getName();
    }

    public Signature getSignature() {
        return this.original.getSignature();
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.annotated instanceof GraphProvider) {
            return ((GraphProvider)this.annotated).buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    public byte[] getCode() {
        return this.annotated.getCode();
    }

    public int getCodeSize() {
        return this.annotated.getCodeSize();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.inClassSubstitution ? this.annotated.getDeclaringClass() : this.original.getDeclaringClass();
    }

    public int getMaxLocals() {
        return this.annotated.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.annotated.getMaxStackSize();
    }

    public int getModifiers() {
        return this.annotated.getModifiers();
    }

    public boolean isSynthetic() {
        return this.annotated.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.annotated.isVarArgs();
    }

    public boolean isBridge() {
        return this.annotated.isBridge();
    }

    public boolean isClassInitializer() {
        return this.original.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.original.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        return this.original.canBeStaticallyBound();
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.annotated.getExceptionHandlers();
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.annotated.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw VMError.unimplemented();
    }

    public ConstantPool getConstantPool() {
        return this.annotated.getConstantPool();
    }

    public Annotation[] getAnnotations() {
        return this.annotated.getAnnotations();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotated.getDeclaredAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotated.getAnnotation(annotationClass);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.annotated.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.original.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        throw VMError.unimplemented();
    }

    public boolean hasNeverInlineDirective() {
        throw VMError.unimplemented();
    }

    public boolean shouldBeInlined() {
        throw VMError.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return this.annotated.getLineNumberTable();
    }

    public String toString() {
        return "SubstitutionMethod<definition " + this.original.toString() + ", implementation " + this.annotated.toString() + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw VMError.unimplemented();
    }

    public Constant getEncoding() {
        throw VMError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return false;
    }

    public boolean isDefault() {
        throw VMError.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.shouldNotReachHere();
    }
}

