/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalUtils;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.TruffleCompilerOptions;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CancellableCompileTask;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.LoopNodeFactory;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateTruffleRuntime
extends GraalTruffleRuntime {
    private static final int DEBUG_TEAR_DOWN_TIMEOUT = 2000;
    private static final int PRODUCTION_TEAR_DOWN_TIMEOUT = 10000;
    private BackgroundCompileQueue compileQueue;
    private GraalTruffleRuntime.CallMethods hostedCallMethods;
    private boolean initialized;

    protected BackgroundCompileQueue getCompileQueue() {
        assert (this.compileQueue != null);
        return this.compileQueue;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleRuntime() {
        super(() -> (GraalRuntime)ImageSingletons.lookup(GraalRuntime.class), Collections.emptyList());
        super.getLoopNodeFactory();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetHosted() {
        this.truffleCompiler = null;
    }

    public void initializeAtRuntime() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            this.compileQueue = new BackgroundCompileQueue();
            RuntimeSupport.getRuntimeSupport().addTearDownHook(this::tearDown);
        }
        if (((Boolean)TruffleCompilerOptions.TraceTruffleTransferToInterpreter.getValue((OptionValues)RuntimeOptionValues.singleton())).booleanValue()) {
            if (!SubstrateOptions.IncludeNodeSourcePositions.getValue().booleanValue()) {
                System.out.println("Warning: " + TruffleCompilerOptions.TraceTruffleTransferToInterpreter.getName() + " cannot print stack traces. Build image with -H:+IncludeNodeSourcePositions to enable stack traces.");
            }
            RuntimeOptionValues.singleton().update(Deoptimizer.Options.TraceDeoptimization, true);
        }
        SubstrateGraalUtils.updateGraalArchitectureWithHostCPUFeatures(this.getTruffleCompiler().getBackend());
        this.installDefaultListeners();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler initTruffleCompiler() {
        assert (this.truffleCompiler == null) : "Cannot re-initialize Substrate TruffleCompiler";
        GraalFeature graalFeature = (GraalFeature)ImageSingletons.lookup(GraalFeature.class);
        SnippetReflectionProvider snippetReflection = graalFeature.getHostedProviders().getSnippetReflection();
        SubstrateTruffleCompiler compiler = new SubstrateTruffleCompiler((TruffleCompilerRuntime)this, graalFeature.getHostedProviders().getGraphBuilderPlugins(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), GraalSupport.getRuntimeConfig().getBackendForNormalMethod(), snippetReflection);
        this.truffleCompiler = compiler;
        return compiler;
    }

    public ResolvedJavaMethod[] getAnyFrameMethod() {
        return this.callMethods.anyFrameMethod;
    }

    protected String getCompilerConfigurationName() {
        SubstrateTruffleCompiler compiler = this.getTruffleCompiler();
        if (compiler != null) {
            return compiler.getCompilerConfigurationName();
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateTruffleCompiler newTruffleCompiler() {
        GraalFeature graalFeature = (GraalFeature)ImageSingletons.lookup(GraalFeature.class);
        SnippetReflectionProvider snippetReflectionProvider = graalFeature.getHostedProviders().getSnippetReflection();
        return new SubstrateTruffleCompiler((TruffleCompilerRuntime)this, graalFeature.getHostedProviders().getGraphBuilderPlugins(), GraalSupport.getSuites(), GraalSupport.getLIRSuites(), GraalSupport.getRuntimeConfig().getBackendForNormalMethod(), snippetReflectionProvider);
    }

    private void tearDown() {
        long timeout = SubstrateUtil.assertionsEnabled() ? 2000L : 10000L;
        this.getCompileQueue().shutdownAndAwaitTermination(timeout);
    }

    public SubstrateTruffleCompiler getTruffleCompiler() {
        return (SubstrateTruffleCompiler)this.truffleCompiler;
    }

    protected LoopNodeFactory getLoopNodeFactory() {
        if (this.loopNodeFactory == null) {
            throw VMError.shouldNotReachHere("loopNodeFactory not initialized");
        }
        return this.loopNodeFactory;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void lookupCallMethods(MetaAccessProvider metaAccess) {
        super.lookupCallMethods(metaAccess);
        this.hostedCallMethods = GraalTruffleRuntime.CallMethods.lookup((MetaAccessProvider)GraalAccess.getOriginalProviders().getMetaAccess());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void clearState() {
        super.clearState();
        this.hostedCallMethods = null;
    }

    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (SubstrateUtil.HOSTED) {
            return this.hostedCallMethods;
        }
        return this.callMethods;
    }

    public OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        if (!SubstrateUtil.HOSTED && !this.initialized) {
            this.initializeAtRuntime();
            this.initialized = true;
        }
        return TruffleFeature.getSupport().createOptimizedCallTarget(source, rootNode);
    }

    public SpeculationLog createSpeculationLog() {
        return new SubstrateSpeculationLog();
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellableCompileTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        if (SubstrateUtil.HOSTED) {
            return null;
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return super.submitForCompilation(optimizedCallTarget, lastTierCompilation);
        }
        try {
            this.doCompile((OptionValues)RuntimeOptionValues.singleton(), optimizedCallTarget, null);
        }
        catch (OptimizationFailedException e) {
            if (((Boolean)TruffleCompilerOptions.TruffleCompilationExceptionsArePrinted.getValue((OptionValues)RuntimeOptionValues.singleton())).booleanValue()) {
                StringWriter string = new StringWriter();
                e.printStackTrace(new PrintWriter(string));
                Log.log().string(string.toString());
            }
        }
        finally {
            optimizedCallTarget.resetCompilationTask();
        }
        return null;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CancellableCompileTask task, boolean mayBeAsynchronous) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            super.finishCompilation(optimizedCallTarget, task, mayBeAsynchronous);
        }
    }

    public boolean cancelInstalledTask(OptimizedCallTarget optimizedCallTarget, Object source, CharSequence reason) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return super.cancelInstalledTask(optimizedCallTarget, source, reason);
        }
        return false;
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            super.waitForCompilation(optimizedCallTarget, timeout);
            return;
        }
    }

    public boolean isCompiling(OptimizedCallTarget optimizedCallTarget) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return super.isCompiling(optimizedCallTarget);
        }
        return false;
    }

    protected StackIntrospection getStackIntrospection() {
        return SubstrateStackIntrospection.SINGLETON;
    }

    public OptionValues getInitialOptions() {
        return RuntimeOptionValues.singleton();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void resetNativeImageState() {
        this.clearState();
    }
}

