/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.util.TimeUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import sun.management.Util;

final class GarbageCollectorManagementFactory {
    private List<GarbageCollectorMXBean> gcBeanList;

    GarbageCollectorManagementFactory() {
        ArrayList<GarbageCollectorMXBean> newList = new ArrayList<GarbageCollectorMXBean>();
        newList.add(new IncrementalGarbageCollectorMXBean());
        newList.add(new CompleteGarbageCollectorMXBean());
        this.gcBeanList = newList;
    }

    List<GarbageCollectorMXBean> getGCBeanList() {
        return this.gcBeanList;
    }

    private static final class CompleteGarbageCollectorMXBean
    implements GarbageCollectorMXBean,
    NotificationEmitter {
        private CompleteGarbageCollectorMXBean() {
        }

        @Override
        public long getCollectionCount() {
            return HeapImpl.getHeapImpl().getGCImpl().getAccounting().getCompleteCollectionCount();
        }

        @Override
        public long getCollectionTime() {
            long nanos = HeapImpl.getHeapImpl().getGCImpl().getAccounting().getCompleteCollectionTotalNanos();
            return TimeUtils.roundNanosToMillis(nanos);
        }

        @Override
        public String[] getMemoryPoolNames() {
            return new String[]{"young generation space", "old generation space"};
        }

        @Override
        public String getName() {
            return "complete scavenger";
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public ObjectName getObjectName() {
            return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
        }

        @Override
        public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void removeNotificationListener(NotificationListener listener) {
        }

        @Override
        public MBeanNotificationInfo[] getNotificationInfo() {
            return new MBeanNotificationInfo[0];
        }
    }

    private static final class IncrementalGarbageCollectorMXBean
    implements GarbageCollectorMXBean,
    NotificationEmitter {
        private IncrementalGarbageCollectorMXBean() {
        }

        @Override
        public long getCollectionCount() {
            return HeapImpl.getHeapImpl().getGCImpl().getAccounting().getIncrementalCollectionCount();
        }

        @Override
        public long getCollectionTime() {
            long nanos = HeapImpl.getHeapImpl().getGCImpl().getAccounting().getIncrementalCollectionTotalNanos();
            return TimeUtils.roundNanosToMillis(nanos);
        }

        @Override
        public String[] getMemoryPoolNames() {
            return new String[]{"young generation space"};
        }

        @Override
        public String getName() {
            return "young generation scavenger";
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public ObjectName getObjectName() {
            return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
        }

        @Override
        public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        }

        @Override
        public void removeNotificationListener(NotificationListener listener) {
        }

        @Override
        public MBeanNotificationInfo[] getNotificationInfo() {
            return new MBeanNotificationInfo[0];
        }
    }
}

