/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import java.util.BitSet;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class DimensionsNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<DimensionsNode> TYPE = NodeClass.create(DimensionsNode.class);
    @Node.Input
    protected ValueNode rank;

    protected DimensionsNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode rank) {
        super(TYPE, stamp);
        this.rank = rank;
    }

    public void generate(NodeLIRBuilderTool gen) {
        int size = this.rank.asJavaConstant().asInt() * 4;
        int wordSize = gen.getLIRGeneratorTool().target().wordSize;
        int slots = NumUtil.roundUp((int)size, (int)wordSize) / wordSize;
        VirtualStackSlot array = gen.getLIRGeneratorTool().allocateStackSlots(slots, new BitSet(0), null);
        Variable result = gen.getLIRGeneratorTool().emitAddress((AllocatableValue)array);
        gen.setResult((ValueNode)this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Pointer allocaDimsArray(int var0);
}

