/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.TimeUtils;

final class SleepSupport {
    private SleepSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ParkEvent.WaitResult sleep(long delayNanos) {
        VMOperationControl.guaranteeOkayToBlock("[SleepSupport.sleep(long): Should not sleep when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        ParkEvent sleepEvent = SleepSupport.ensureSleepEvent(thread);
        long startNanos = System.nanoTime();
        long endNanos = TimeUtils.addOrMaxValue(startNanos, delayNanos);
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 225);
        try {
            long remainingNanos = delayNanos;
            while (0L < remainingNanos) {
                ParkEvent.WaitResult result = sleepEvent.condTimedWait(remainingNanos);
                if (result == ParkEvent.WaitResult.INTERRUPTED || result == ParkEvent.WaitResult.UNPARKED) {
                    ParkEvent.WaitResult waitResult = result;
                    return waitResult;
                }
                remainingNanos = endNanos - System.nanoTime();
            }
            ParkEvent.WaitResult waitResult = ParkEvent.WaitResult.TIMED_OUT;
            return waitResult;
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    protected static void interrupt(Thread thread) {
        ParkEvent sleepEvent = JavaThreads.getSleepParkEvent(thread).get();
        if (sleepEvent != null) {
            sleepEvent.unpark();
        }
    }

    private static ParkEvent ensureSleepEvent(Thread thread) {
        return ParkEvent.initializeOnce(JavaThreads.getSleepParkEvent(thread), true);
    }
}

