/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.util;

import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static void drainInputStream(InputStream source, OutputStream sink) {
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = source.read(buffer)) != -1) {
                sink.write(buffer, 0, read);
            }
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    public static List<String> readAllLines(InputStream source) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(source));
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

