/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CCallStubMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.util.Arrays;
import java.util.List;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public final class CFunctionPointerCallStubMethod
extends CCallStubMethod {
    static CFunctionPointerCallStubMethod create(AnalysisMethod aMethod) {
        assert (!aMethod.isSynthetic()) : "Creating a stub for a stub? " + aMethod;
        ResolvedJavaMethod method = aMethod.getWrapped();
        boolean needsTransition = ((InvokeCFunctionPointer)aMethod.getAnnotation(InvokeCFunctionPointer.class)).transition() != CFunction.Transition.NO_TRANSITION;
        return new CFunctionPointerCallStubMethod(method, needsTransition);
    }

    private CFunctionPointerCallStubMethod(ResolvedJavaMethod original, boolean needsTransition) {
        super(original, needsTransition);
    }

    @Override
    public Signature getSignature() {
        return new Signature(){
            private final Signature wrapped;
            {
                this.wrapped = CFunctionPointerCallStubMethod.this.getOriginal().getSignature();
            }

            public int getParameterCount(boolean receiver) {
                return this.wrapped.getParameterCount(true);
            }

            public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
                if (index == 0) {
                    return CFunctionPointerCallStubMethod.this.getOriginal().getDeclaringClass().resolve(accessingClass);
                }
                return this.wrapped.getParameterType(index - 1, accessingClass);
            }

            public JavaType getReturnType(ResolvedJavaType accessingClass) {
                return this.wrapped.getReturnType(accessingClass);
            }
        };
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFF9FF | 8;
    }

    @Override
    public boolean canBeStaticallyBound() {
        return true;
    }

    @Override
    protected String getCorrespondingAnnotationName() {
        return InvokeCFunctionPointer.class.getSimpleName();
    }

    @Override
    public boolean allowRuntimeCompilation() {
        return !this.needsTransition;
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        assert (purpose != GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION || this.allowRuntimeCompilation());
        return super.buildGraph(debug, method, providers, purpose);
    }

    @Override
    protected JavaType[] getParameterTypesForLoad(ResolvedJavaMethod method) {
        return method.toParameterTypes();
    }

    @Override
    protected ValueNode createTargetAddressNode(HostedGraphKit kit, HostedProviders providers, List<ValueNode> arguments) {
        return arguments.get(0);
    }

    @Override
    protected Signature adaptSignatureAndConvertArguments(HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, JavaType returnType, JavaType[] paramTypes, List<ValueNode> arguments) {
        arguments.remove(0);
        JavaType[] paramTypesNoReceiver = Arrays.copyOfRange(paramTypes, 1, paramTypes.length);
        return super.adaptSignatureAndConvertArguments(providers, nativeLibraries, kit, returnType, paramTypesNoReceiver, arguments);
    }
}

