/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.nodes.SubstrateVirtualArrayNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class SubstrateArraysCopyOfNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
VirtualizableAllocation {
    public static final NodeClass<SubstrateArraysCopyOfNode> TYPE = NodeClass.create(SubstrateArraysCopyOfNode.class);
    @Node.Input
    ValueNode original;
    @Node.Input
    ValueNode originalLength;
    @Node.Input
    ValueNode newLength;
    @Node.Input
    ValueNode newArrayType;

    public SubstrateArraysCopyOfNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode original, ValueNode originaLength, ValueNode newLength, ValueNode newArrayType) {
        super(TYPE, SubstrateArraysCopyOfNode.computeStamp(stamp));
        this.original = original;
        this.originalLength = originaLength;
        this.newLength = newLength;
        this.newArrayType = newArrayType;
    }

    public ValueNode getOriginal() {
        return this.original;
    }

    public ValueNode getOriginaLength() {
        return this.originalLength;
    }

    public ValueNode getNewArrayType() {
        return this.newArrayType;
    }

    public ValueNode getNewLength() {
        return this.newLength;
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    public boolean canDeoptimize() {
        return true;
    }

    private static Stamp computeStamp(Stamp result) {
        if (result instanceof ObjectStamp) {
            return result.join(StampFactory.objectNonNull());
        }
        return result;
    }

    public void virtualize(VirtualizerTool tool) {
        if (!this.newArrayType.isConstant()) {
            return;
        }
        ConstantNode from = ConstantNode.forInt((int)0);
        ResolvedJavaType newComponentType = tool.getConstantReflection().asJavaType(this.newArrayType.asConstant()).getComponentType();
        GraphUtil.virtualizeArrayCopy((VirtualizerTool)tool, (ValueNode)this.original, (ValueNode)this.originalLength, (ValueNode)this.newLength, (ValueNode)from, (ResolvedJavaType)newComponentType, (JavaKind)JavaKind.Object, (StructuredGraph)this.graph(), (componentType, length) -> new SubstrateVirtualArrayNode((ResolvedJavaType)componentType, (int)length));
    }
}

