/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.lir;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.nodes.CFunctionEpilogueMarker;
import com.oracle.svm.core.nodes.CFunctionPrologueMarker;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public class VerifyCFunctionReferenceMapsLIRPhase
extends PostAllocationOptimizationPhase {
    protected CharSequence createName() {
        return "VerifyCFunctionReferenceMapsLIRPhase";
    }

    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        LIR ir = lirGenRes.getLIR();
        for (AbstractBlockBase block : ir.linearScanOrder()) {
            ArrayList instructions = ir.getLIRforBlock(block);
            for (int i = 0; i < instructions.size(); ++i) {
                LIRInstruction op = (LIRInstruction)instructions.get(i);
                if (!(op instanceof VerificationMarkerOp) || !(((VerificationMarkerOp)op).getMarker() instanceof CFunctionPrologueMarker)) continue;
                CFunctionPrologueMarker prologueMarker = (CFunctionPrologueMarker)((VerificationMarkerOp)op).getMarker();
                new VerificationInstance(ir, prologueMarker.getEpilogueMarker()).run(block, i);
            }
        }
    }

    static class VerificationInstance {
        private final LIR ir;
        private final CFunctionEpilogueMarker epilogueMarker;
        private final Set<AbstractBlockBase<?>> processed = new HashSet();
        private final Deque<AbstractBlockBase<?>> worklist = new ArrayDeque();
        private final List<LIRFrameState> states = new ArrayList<LIRFrameState>();

        VerificationInstance(LIR ir, CFunctionEpilogueMarker epilogueMarker) {
            this.ir = ir;
            this.epilogueMarker = epilogueMarker;
        }

        void run(AbstractBlockBase<?> startBlock, int startInstruction) {
            this.processBlock(startBlock, startInstruction);
            while (!this.worklist.isEmpty()) {
                this.processBlock(this.worklist.pop(), 0);
            }
            if (this.states.size() < 2) {
                throw VMError.shouldNotReachHere("Expected at least 2 instructions with states, but found " + this.states.size());
            }
            ReferenceMap firstMap = this.states.get(0).debugInfo().getReferenceMap();
            for (LIRFrameState state : this.states) {
                ReferenceMap map = state.debugInfo().getReferenceMap();
                if (firstMap.equals(map)) continue;
                throw VMError.shouldNotReachHere("Reference maps not equal: " + firstMap + ", " + map);
            }
        }

        private void processBlock(AbstractBlockBase<?> block, int startInstruction) {
            this.processed.add(block);
            ArrayList instructions = this.ir.getLIRforBlock(block);
            for (int i = startInstruction; i < instructions.size(); ++i) {
                LIRInstruction op = (LIRInstruction)instructions.get(i);
                if (op instanceof VerificationMarkerOp && ((VerificationMarkerOp)op).getMarker() == this.epilogueMarker) {
                    return;
                }
                op.forEachState(state -> this.states.add(state));
            }
            if (block.getSuccessorCount() == 0) {
                throw VMError.shouldNotReachHere("No epilogue marker found");
            }
            for (AbstractBlockBase successor : block.getSuccessors()) {
                if (this.processed.contains(successor)) continue;
                this.worklist.add(successor);
            }
        }
    }
}

