/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.ReferenceAccess;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ReferenceAccessImpl
implements ReferenceAccess {
    static void initialize() {
        ImageSingletons.add(ReferenceAccess.class, (Object)new ReferenceAccessImpl());
    }

    private ReferenceAccessImpl() {
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="for uninterruptible callers", mayBeInlined=true)
    public Word readObjectAsUntrackedPointer(Pointer p, boolean compressed) {
        Object obj = this.readObjectAt(p, compressed);
        return Word.objectToUntrackedPointer((Object)obj);
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="for uninterruptible callers", mayBeInlined=true)
    public Object readObjectAt(Pointer p, boolean compressed) {
        Word w = (Word)p;
        if (compressed) {
            return ObjectAccess.readObject((Object)WordFactory.nullPointer(), (WordBase)p);
        }
        return w.readObject(0);
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="for uninterruptible callers", mayBeInlined=true)
    public void writeObjectAt(Pointer p, Object value, boolean compressed) {
        Word w = (Word)p;
        if (compressed) {
            ObjectAccess.writeObject((Object)WordFactory.nullPointer(), (WordBase)p, (Object)value);
        } else {
            w.writeObject(0, value);
        }
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="for uninterruptible callers", mayBeInlined=true)
    public void writeObjectBarrieredAt(Object object, UnsignedWord offsetInObject, Object value, boolean compressed) {
        assert (compressed) : "Heap object must contain only compressed references";
        BarrieredAccess.writeObject((Object)object, (WordBase)offsetInObject, (Object)value);
    }

    @Override
    public native UnsignedWord getCompressedRepresentation(Object var1);

    @Override
    public native Object uncompressReference(UnsignedWord var1);

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="for uninterruptible callers", mayBeInlined=true)
    public boolean haveCompressedReferences() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    @Override
    @AlwaysInline(value="Performance")
    @Uninterruptible(reason="for uninterruptible callers", mayBeInlined=true)
    public CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }
}

