/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@Platforms(value={Platform.DARWIN.class, Platform.LINUX.class})
@CContext(value=PosixDirectives.class)
@CLibrary(value="z")
public class ZLib {
    @CFunction
    public static native UnsignedWord adler32(UnsignedWord var0, CCharPointer var1, int var2);

    @CFunction
    public static native UnsignedWord crc32(UnsignedWord var0, CCharPointer var1, int var2);

    @CConstant
    public static native byte[] ZLIB_VERSION();

    @CFunction
    static native int deflateInit2_(z_stream var0, int var1, int var2, int var3, int var4, int var5, CCharPointer var6, int var7);

    public static int deflateInit2(z_stream strm, int level, int method, int windowBits, int memLevel, int strategy) {
        try (PinnedObject zlib_version_byteArray = PinnedObject.create((Object)ZLib.ZLIB_VERSION());){
            CCharPointer zlib_version = (CCharPointer)zlib_version_byteArray.addressOfArrayElement(0);
            int n = ZLib.deflateInit2_(strm, level, method, windowBits, memLevel, strategy, zlib_version, SizeOf.get(z_stream.class));
            return n;
        }
    }

    @CFunction
    public static native int deflateSetDictionary(z_stream var0, CCharPointer var1, int var2);

    @CFunction
    public static native int deflateReset(z_stream var0);

    @CFunction
    public static native int deflateEnd(z_stream var0);

    @CFunction
    public static native int deflateParams(z_stream var0, int var1, int var2);

    @CFunction
    public static native int deflate(z_stream var0, int var1);

    @CFunction
    static native int inflateInit2_(z_stream var0, int var1, CCharPointer var2, int var3);

    public static int inflateInit2(z_stream strm, int windowBits) {
        try (PinnedObject zlib_version_byteArray = PinnedObject.create((Object)ZLib.ZLIB_VERSION());){
            CCharPointer zlib_version = (CCharPointer)zlib_version_byteArray.addressOfArrayElement(0);
            int n = ZLib.inflateInit2_(strm, windowBits, zlib_version, SizeOf.get(z_stream.class));
            return n;
        }
    }

    @CFunction
    public static native int inflateSetDictionary(z_stream var0, CCharPointer var1, int var2);

    @CFunction
    public static native int inflateReset(z_stream var0);

    @CFunction
    public static native int inflateEnd(z_stream var0);

    @CFunction
    public static native int inflate(z_stream var0, int var1);

    @CFunction
    static native int compress(CCharPointer var0, CLongPointer var1, CCharPointer var2, UnsignedWord var3);

    @CFunction
    static native int compress2(CCharPointer var0, CLongPointer var1, CCharPointer var2, UnsignedWord var3, int var4);

    @CFunction
    static native UnsignedWord compressBound(UnsignedWord var0);

    @CFunction
    static native int uncompress(CCharPointer var0, CLongPointer var1, CCharPointer var2, UnsignedWord var3);

    @CConstant
    public static native int MAX_WBITS();

    @CConstant
    public static native int Z_NO_FLUSH();

    @CConstant
    public static native int Z_PARTIAL_FLUSH();

    @CConstant
    public static native int Z_SYNC_FLUSH();

    @CConstant
    public static native int Z_FULL_FLUSH();

    @CConstant
    public static native int Z_FINISH();

    @CConstant
    public static native int Z_BLOCK();

    @CConstant
    public static native int Z_OK();

    @CConstant
    public static native int Z_STREAM_END();

    @CConstant
    public static native int Z_NEED_DICT();

    @CConstant
    public static native int Z_ERRNO();

    @CConstant
    public static native int Z_STREAM_ERROR();

    @CConstant
    public static native int Z_DATA_ERROR();

    @CConstant
    public static native int Z_MEM_ERROR();

    @CConstant
    public static native int Z_BUF_ERROR();

    @CConstant
    public static native int Z_VERSION_ERROR();

    @CConstant
    public static native int Z_NO_COMPRESSION();

    @CConstant
    public static native int Z_BEST_SPEED();

    @CConstant
    public static native int Z_BEST_COMPRESSION();

    @CConstant
    public static native int Z_DEFAULT_COMPRESSION();

    @CConstant
    public static native int Z_FILTERED();

    @CConstant
    public static native int Z_HUFFMAN_ONLY();

    @CConstant
    public static native int Z_RLE();

    @CConstant
    public static native int Z_FIXED();

    @CConstant
    public static native int Z_DEFAULT_STRATEGY();

    @CConstant
    public static native int Z_BINARY();

    @CConstant
    public static native int Z_TEXT();

    @CConstant
    public static native int Z_ASCII();

    @CConstant
    public static native int Z_UNKNOWN();

    @CConstant
    public static native int Z_DEFLATED();

    @CConstant
    public static native int Z_NULL();

    @CStruct
    public static interface gz_header
    extends PointerBase {
        @CField
        public int text();

        @CField
        public UnsignedWord time();

        @CField
        public int xflags();

        @CField
        public int os();

        @CField
        public CCharPointer extra();

        @CField
        public int extra_len();

        @CField
        public int extra_max();

        @CField
        public CCharPointer name();

        @CField
        public int name_max();

        @CField
        public CCharPointer comment();

        @CField
        public int comm_max();

        @CField
        public int hcrc();

        @CField
        public int done();
    }

    @CStruct
    public static interface z_stream
    extends PointerBase {
        @CField
        public CCharPointer next_in();

        @CField
        public void set_next_in(CCharPointer var1);

        @CField
        public int avail_in();

        @CField
        public void set_avail_in(int var1);

        @CField
        public UnsignedWord total_in();

        @CField
        public CCharPointer next_out();

        @CField
        public void set_next_out(CCharPointer var1);

        @CField
        public int avail_out();

        @CField
        public void set_avail_out(int var1);

        @CField
        public UnsignedWord total_out();

        @CField
        public CCharPointer msg();

        @CField
        public WordPointer state();

        @CField
        public alloc_func zalloc();

        @CField
        public free_func zfree();

        @CField
        public WordPointer opaque();

        @CField
        public int data_type();

        @CField
        public UnsignedWord adler();

        @CField
        public UnsignedWord reserved();
    }

    static interface free_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void invoke(WordPointer var1, WordPointer var2);
    }

    static interface alloc_func
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public WordPointer invoke(WordPointer var1, int var2, int var3);
    }
}

