/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteOperation;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OSBTreeBonsaiRemote<K, V>
implements OSBTreeBonsai<K, V> {
    private final OBonsaiCollectionPointer treePointer;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;

    public OSBTreeBonsaiRemote(OBonsaiCollectionPointer treePointer, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.treePointer = treePointer;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public long getFileId() {
        return this.treePointer.getFileId();
    }

    public OBonsaiBucketPointer getRootBucketPointer() {
        return this.treePointer.getRootPointer();
    }

    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.treePointer;
    }

    public V get(K key) {
        final OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        final byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        return (V)storage.networkOperation(new OStorageRemoteOperation<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V execute(OChannelBinaryAsynchClient client, OStorageRemoteSession session) throws IOException {
                byte[] stream;
                storage.beginRequest(client, (byte)111, session);
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, OSBTreeBonsaiRemote.this.getCollectionPointer());
                client.writeBytes(keyStream);
                storage.endRequest(client);
                try {
                    storage.beginResponse(client, session);
                    stream = client.readBytes();
                }
                finally {
                    storage.endResponse(client);
                }
                byte serializerId = OByteSerializer.INSTANCE.deserializeLiteral(stream, 0);
                OBinarySerializer serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
                return serializer.deserialize(stream, 1);
            }
        }, "Cannot get by key from sb-tree bonsai");
    }

    public boolean put(K key, V value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public V remove(K key) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void clear() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void delete() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long size() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<V> getValuesMinor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Collection<V> getValuesMajor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void loadEntriesMajor(K key, boolean inclusive, boolean ascSortOrder, OTreeInternal.RangeResultListener<K, V> listener) {
        if (!ascSortOrder) {
            throw new IllegalStateException("Descending sort order is not supported");
        }
        List<Map.Entry<K, V>> entries = this.fetchEntriesMajor(key, inclusive);
        while (this.pushEntriesToListener(listener, entries)) {
            K nextKey = entries.get(entries.size() - 1).getKey();
            entries = this.fetchEntriesMajor(nextKey, false);
        }
    }

    private boolean pushEntriesToListener(OTreeInternal.RangeResultListener<K, V> listener, List<Map.Entry<K, V>> entries) {
        boolean more = false;
        for (Map.Entry<K, V> entry : entries) {
            more = listener.addResult(entry);
            if (more) continue;
            return false;
        }
        return more;
    }

    private List<Map.Entry<K, V>> fetchEntriesMajor(K key, final boolean inclusive) {
        final byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        final OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        return (List)storage.networkOperation(new OStorageRemoteOperation<List<Map.Entry<K, V>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Map.Entry<K, V>> execute(OChannelBinaryAsynchClient client, OStorageRemoteSession session) throws IOException {
                try {
                    storage.beginRequest(client, (byte)113, session);
                    OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, OSBTreeBonsaiRemote.this.getCollectionPointer());
                    client.writeBytes(keyStream);
                    client.writeBoolean(inclusive);
                    if (client.getSrvProtocolVersion() >= 21) {
                        client.writeInt(128);
                    }
                }
                finally {
                    storage.endRequest(client);
                }
                ArrayList list = null;
                try {
                    storage.beginResponse(client, session);
                    byte[] stream = client.readBytes();
                    int offset = 0;
                    int count = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, 0);
                    offset += 4;
                    list = new ArrayList(count);
                    for (int i = 0; i < count; ++i) {
                        Object resultKey = OSBTreeBonsaiRemote.this.keySerializer.deserialize(stream, offset);
                        offset += OSBTreeBonsaiRemote.this.keySerializer.getObjectSize(stream, offset);
                        Object resultValue = OSBTreeBonsaiRemote.this.valueSerializer.deserialize(stream, offset);
                        offset += OSBTreeBonsaiRemote.this.valueSerializer.getObjectSize(stream, offset);
                        list.add(new TreeEntry<Object, Object>(resultKey, resultValue));
                    }
                }
                finally {
                    storage.endResponse(client);
                }
                return list;
            }
        }, "Cannot get first key from sb-tree bonsai");
    }

    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public K firstKey() {
        final OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        return (K)storage.networkOperation(new OStorageRemoteOperation<K>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public K execute(OChannelBinaryAsynchClient client, OStorageRemoteSession session) throws IOException {
                byte[] stream;
                storage.beginRequest(client, (byte)112, session);
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, OSBTreeBonsaiRemote.this.getCollectionPointer());
                storage.endRequest(client);
                try {
                    storage.beginResponse(client, session);
                    stream = client.readBytes();
                }
                finally {
                    storage.endResponse(client);
                }
                byte serializerId = OByteSerializer.INSTANCE.deserializeLiteral(stream, 0);
                OBinarySerializer serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
                return serializer.deserialize(stream, 1);
            }
        }, "Cannot get first key from sb-tree bonsai");
    }

    public K lastKey() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getRealBagSize(final Map<K, OSBTreeRidBag.Change> changes) {
        final OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        return storage.networkOperation(new OStorageRemoteOperation<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer execute(OChannelBinaryAsynchClient client, OStorageRemoteSession session) throws IOException {
                int result;
                try {
                    storage.beginRequest(client, (byte)114, session);
                    OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, OSBTreeBonsaiRemote.this.getCollectionPointer());
                    OSBTreeRidBag.ChangeSerializationHelper changeSerializer = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE;
                    byte[] stream = new byte[4 + changeSerializer.getChangesSerializedSize(changes.size())];
                    changeSerializer.serializeChanges(changes, OSBTreeBonsaiRemote.this.keySerializer, stream, 0);
                    client.writeBytes(stream);
                }
                finally {
                    storage.endRequest(client);
                }
                try {
                    storage.beginResponse(client, session);
                    result = client.readInt();
                }
                finally {
                    storage.endResponse(client);
                }
                return result;
            }
        }, "Cannot get by real bag size sb-tree bonsai");
    }

    public OBinarySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OBinarySerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    class TreeEntry<EK, EV>
    implements Map.Entry<EK, EV> {
        private final EK key;
        private final EV value;

        TreeEntry(EK key, EV value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public EK getKey() {
            return this.key;
        }

        @Override
        public EV getValue() {
            return this.value;
        }

        @Override
        public EV setValue(EV value) {
            throw new UnsupportedOperationException();
        }
    }
}

