/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.remote.message.OLiveQueryPushRequest;
import com.orientechnologies.orient.client.remote.message.live.OLiveQueryResult;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;

public class OLiveQueryClientListener {
    private ODatabaseDocument database;
    private OLiveQueryResultListener listener;

    public OLiveQueryClientListener(ODatabaseDocument database, OLiveQueryResultListener listener) {
        this.database = database;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onEvent(OLiveQueryPushRequest pushRequest) {
        ODatabaseDocumentInternal old = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.database.activateOnCurrentThread();
            if (pushRequest.getStatus() == 3) {
                this.onError(pushRequest.getErrorCode().newException(pushRequest.getErrorMessage(), null));
                boolean bl = true;
                return bl;
            }
            for (OLiveQueryResult result : pushRequest.getEvents()) {
                switch (result.getEventType()) {
                    case 1: {
                        this.listener.onCreate(this.database, result.getCurrentValue());
                        break;
                    }
                    case 2: {
                        this.listener.onUpdate(this.database, result.getOldValue(), result.getCurrentValue());
                        break;
                    }
                    case 3: {
                        this.listener.onDelete(this.database, result.getCurrentValue());
                    }
                }
            }
            if (pushRequest.getStatus() == 2) {
                this.onEnd();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(old);
        }
    }

    public void onError(OException e) {
        ODatabaseDocumentInternal old = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.database.activateOnCurrentThread();
            this.listener.onError(this.database, e);
            this.database.close();
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(old);
        }
    }

    public void onEnd() {
        ODatabaseDocumentInternal old = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            this.database.activateOnCurrentThread();
            this.listener.onEnd(this.database);
            this.database.close();
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(old);
        }
    }
}

