/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OAddClusterResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public final class OAddClusterRequest
implements OBinaryRequest<OAddClusterResponse> {
    private int requestedId = -1;
    private String clusterName;

    public OAddClusterRequest(int iRequestedId, String iClusterName) {
        this.requestedId = iRequestedId;
        this.clusterName = iClusterName;
    }

    public OAddClusterRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeString(this.clusterName);
        network.writeShort((short)this.requestedId);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        String type = "";
        if (protocolVersion < 24) {
            type = channel.readString();
        }
        this.clusterName = channel.readString();
        if (protocolVersion < 24 || type.equalsIgnoreCase("PHYSICAL")) {
            channel.readString();
        }
        if (protocolVersion < 24) {
            channel.readString();
        }
        this.requestedId = channel.readShort();
    }

    @Override
    public byte getCommand() {
        return 10;
    }

    @Override
    public String getDescription() {
        return "Add cluster";
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getRequestedId() {
        return this.requestedId;
    }

    @Override
    public OAddClusterResponse createResponse() {
        return new OAddClusterResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeAddCluster(this);
    }
}

