/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OSubscribeDistributedConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeFunctionsRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeIndexManagerRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeLiveQueryRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeSchemaRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeSequencesRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeStorageConfigurationRequest;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OSubscribeRequest
implements OBinaryRequest<OSubscribeResponse> {
    private byte pushMessage;
    private OBinaryRequest<? extends OBinaryResponse> pushRequest;

    public OSubscribeRequest() {
    }

    public OSubscribeRequest(OBinaryRequest<? extends OBinaryResponse> request) {
        this.pushMessage = request.getCommand();
        this.pushRequest = request;
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeByte(this.pushMessage);
        this.pushRequest.write(network, session);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.pushMessage = channel.readByte();
        this.pushRequest = this.createBinaryRequest(this.pushMessage);
        this.pushRequest.read(channel, protocolVersion, serializer);
    }

    private OBinaryRequest<? extends OBinaryResponse> createBinaryRequest(byte message) {
        switch (message) {
            case 1: {
                return new OSubscribeDistributedConfigurationRequest();
            }
            case 2: {
                return new OSubscribeLiveQueryRequest();
            }
            case 3: {
                return new OSubscribeStorageConfigurationRequest();
            }
            case 4: {
                return new OSubscribeSchemaRequest();
            }
            case 5: {
                return new OSubscribeIndexManagerRequest();
            }
            case 6: {
                return new OSubscribeFunctionsRequest();
            }
            case 7: {
                return new OSubscribeSequencesRequest();
            }
        }
        throw new ODatabaseException("Unknown message response for code:" + message);
    }

    @Override
    public byte getCommand() {
        return 100;
    }

    @Override
    public OSubscribeResponse createResponse() {
        return new OSubscribeResponse(this.pushRequest.createResponse());
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeSubscribe(this);
    }

    public byte getPushMessage() {
        return this.pushMessage;
    }

    public OBinaryRequest<? extends OBinaryResponse> getPushRequest() {
        return this.pushRequest;
    }

    @Override
    public String getDescription() {
        return "Subscribe to push message";
    }
}

