/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.orient.client.remote.ORemoteURLs;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTxInternal;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

@Deprecated
public class OServerAdmin {
    protected OStorageRemoteSession session = new OStorageRemoteSession(-1);
    protected String clientType = "OrientDB Java";
    protected boolean collectStats = true;
    private final ORemoteURLs urls;
    private final OrientDBRemote remote;
    private String user;
    private String password;
    private Optional<String> database;

    @Deprecated
    public OServerAdmin(String iURL) throws IOException {
        String url = iURL;
        if (url.startsWith("remote")) {
            url = url.substring("remote".length() + 1);
        }
        if (!url.contains("/")) {
            url = url + "/";
        }
        this.remote = (OrientDBRemote)ODatabaseDocumentTxInternal.getOrCreateRemoteFactory((String)url);
        this.urls = new ORemoteURLs(new String[0], this.remote.getContextConfiguration());
        String name = this.urls.parseServerUrls(url, this.remote.getContextConfiguration());
        this.database = name != null && name.length() != 0 ? Optional.of(name) : Optional.empty();
    }

    public OServerAdmin(OrientDBRemote remote, String url) throws IOException {
        this.remote = remote;
        this.urls = new ORemoteURLs(new String[0], remote.getContextConfiguration());
        String name = this.urls.parseServerUrls(url, remote.getContextConfiguration());
        this.database = name != null && name.length() != 0 ? Optional.of(name) : Optional.empty();
    }

    @Deprecated
    public OServerAdmin(OStorageRemote iStorage) {
        this.remote = iStorage.context;
        this.urls = new ORemoteURLs(new String[0], this.remote.getContextConfiguration());
        this.urls.parseServerUrls(iStorage.getURL(), this.remote.getContextConfiguration());
        this.database = Optional.ofNullable(iStorage.getName());
    }

    @Deprecated
    public synchronized OServerAdmin connect(String iUserName, String iUserPassword) throws IOException {
        this.user = iUserName;
        this.password = iUserPassword;
        return this;
    }

    private void checkConnected() {
        if (this.user == null || this.password == null) {
            throw new OStorageException("OServerAdmin not connect use connect before do an operation");
        }
    }

    @Deprecated
    public synchronized Map<String, String> listDatabases() throws IOException {
        this.checkConnected();
        return this.remote.getDatabases(this.user, this.password);
    }

    @Deprecated
    public synchronized ODocument getServerInfo() throws IOException {
        this.checkConnected();
        return this.remote.getServerInfo(this.user, this.password);
    }

    public int getSessionId() {
        return this.session.getSessionId();
    }

    @Deprecated
    public synchronized OServerAdmin createDatabase(String iStorageMode) throws IOException {
        return this.createDatabase("document", iStorageMode);
    }

    @Deprecated
    public synchronized OServerAdmin createDatabase(String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(this.getStorageName(), iDatabaseType, iStorageMode);
    }

    public synchronized String getStorageName() {
        return this.database.get();
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseName, String iDatabaseType, String iStorageMode) throws IOException {
        return this.createDatabase(iDatabaseName, iDatabaseType, iStorageMode, null);
    }

    public synchronized OServerAdmin createDatabase(String iDatabaseName, String iDatabaseType, String iStorageMode, String backupPath) throws IOException {
        this.checkConnected();
        ODatabaseType storageMode = iStorageMode == null ? ODatabaseType.PLOCAL : ODatabaseType.valueOf((String)iStorageMode.toUpperCase());
        OrientDBConfig config = OrientDBConfig.builder().addConfig(OGlobalConfiguration.CREATE_DEFAULT_USERS, (Object)true).build();
        if (backupPath != null) {
            this.remote.restore(iDatabaseName, this.user, this.password, storageMode, backupPath, null);
        } else {
            this.remote.create(iDatabaseName, this.user, this.password, storageMode, config);
        }
        return this;
    }

    public synchronized boolean existsDatabase() throws IOException {
        return this.existsDatabase(this.database.get(), null);
    }

    public synchronized boolean existsDatabase(String iDatabaseName, String storageType) throws IOException {
        this.checkConnected();
        return this.remote.exists(iDatabaseName, this.user, this.password);
    }

    public synchronized boolean existsDatabase(String storageType) throws IOException {
        this.checkConnected();
        return this.existsDatabase(this.getStorageName(), storageType);
    }

    @Deprecated
    public OServerAdmin deleteDatabase(String storageType) throws IOException {
        return this.dropDatabase(this.getStorageName(), storageType);
    }

    public synchronized OServerAdmin dropDatabase(String iDatabaseName, String storageType) throws IOException {
        this.checkConnected();
        this.remote.drop(iDatabaseName, this.user, this.password);
        return this;
    }

    public synchronized OServerAdmin dropDatabase(String storageType) throws IOException {
        return this.dropDatabase(this.getStorageName(), storageType);
    }

    public synchronized OServerAdmin freezeDatabase(String storageType) throws IOException {
        this.checkConnected();
        this.remote.freezeDatabase(this.getStorageName(), this.user, this.password);
        return this;
    }

    public synchronized OServerAdmin releaseDatabase(String storageType) throws IOException {
        this.checkConnected();
        this.remote.releaseDatabase(this.getStorageName(), this.user, this.password);
        return this;
    }

    public ODocument clusterStatus() {
        this.checkConnected();
        return this.remote.getClusterStatus(this.user, this.password);
    }

    public synchronized Map<String, String> getGlobalConfigurations() throws IOException {
        this.checkConnected();
        return this.remote.getGlobalConfigurations(this.user, this.password);
    }

    public synchronized String getGlobalConfiguration(OGlobalConfiguration config) throws IOException {
        this.checkConnected();
        return this.remote.getGlobalConfiguration(this.user, this.password, config);
    }

    public synchronized OServerAdmin setGlobalConfiguration(OGlobalConfiguration config, Object iValue) throws IOException {
        this.checkConnected();
        this.remote.setGlobalConfiguration(this.user, this.password, config, iValue.toString());
        return this;
    }

    public synchronized void close() {
    }

    public synchronized void close(boolean iForce) {
    }

    public synchronized String getURL() {
        String url = String.join((CharSequence)";", this.urls.getUrls());
        if (this.database.isPresent()) {
            url = url + "/" + this.database.get();
        }
        return "remote:" + url;
    }

    public boolean isConnected() {
        return this.user != null && this.password != null;
    }
}

