/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsResponse;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OFloorPhysicalPositionsRequest
implements OBinaryRequest<OFloorPhysicalPositionsResponse> {
    private OPhysicalPosition physicalPosition;
    private int clusterId;

    public OFloorPhysicalPositionsRequest(OPhysicalPosition physicalPosition, int clusterId) {
        this.physicalPosition = physicalPosition;
        this.clusterId = clusterId;
    }

    public OFloorPhysicalPositionsRequest() {
    }

    @Override
    public void write(OChannelDataOutput network, OStorageRemoteSession session) throws IOException {
        network.writeInt(this.clusterId);
        network.writeLong(this.physicalPosition.clusterPosition);
    }

    @Override
    public void read(OChannelDataInput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        this.clusterId = channel.readInt();
        this.physicalPosition = new OPhysicalPosition(channel.readLong());
    }

    @Override
    public byte getCommand() {
        return 39;
    }

    @Override
    public String getDescription() {
        return "Retrieve floor positions";
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public OPhysicalPosition getPhysicalPosition() {
        return this.physicalPosition;
    }

    @Override
    public OFloorPhysicalPositionsResponse createResponse() {
        return new OFloorPhysicalPositionsResponse();
    }

    @Override
    public OBinaryResponse execute(OBinaryRequestExecutor executor) {
        return executor.executeFloorPosition(this);
    }
}

