/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyRemote;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;

public class OViewRemote
extends OViewImpl {
    protected OViewRemote(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OProperty addProperty(String propertyName, OType type, OType linkedType, OClass linkedClass, boolean unsafe) {
        if (type == null) {
            throw new OSchemaException("Property type not defined.");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new OSchemaException("Property name is null or empty");
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        this.validatePropertyName(propertyName);
        if (database.getTransaction().isActive()) {
            throw new OSchemaException("Cannot create property '" + propertyName + "' inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (linkedType != null) {
            OPropertyImpl.checkLinkTypeSupport((OType)type);
        }
        if (linkedClass != null) {
            OPropertyImpl.checkSupportLinkedClass((OType)type);
        }
        this.acquireSchemaWriteLock();
        try {
            StringBuilder cmd = new StringBuilder("create property ");
            cmd.append('`');
            cmd.append(this.name);
            cmd.append('`');
            cmd.append('.');
            cmd.append('`');
            cmd.append(propertyName);
            cmd.append('`');
            cmd.append(' ');
            cmd.append(type.name);
            if (linkedType != null) {
                cmd.append(' ');
                cmd.append(linkedType.name);
            } else if (linkedClass != null) {
                cmd.append(' ');
                cmd.append('`');
                cmd.append(linkedClass.getName());
                cmd.append('`');
            }
            if (unsafe) {
                cmd.append(" unsafe ");
            }
            database.command(cmd.toString(), new Object[0]).close();
            OProperty oProperty = this.getProperty(propertyName);
            return oProperty;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClassImpl setEncryption(String iValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter view `%s` encryption %s", this.name, iValue);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public OClass setClusterSelection(String value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClassImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter view `%s` custom %s = ?", this.getName(), name);
            database.command(cmd, new Object[]{value}).close();
            OViewRemote oViewRemote = this;
            return oViewRemote;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter view `%s` custom clear", this.getName());
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public OClass setSuperClasses(List<? extends OClass> classes) {
        throw new UnsupportedOperationException();
    }

    public OClass addSuperClass(OClass superClass) {
        throw new UnsupportedOperationException();
    }

    public OClass removeSuperClass(OClass superClass) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView setName(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid((String)name);
        OView oClass = database.getMetadata().getSchema().getView(name);
        if (oClass != null) {
            String error = String.format("Cannot rename view %s to %s. A Class with name %s exists", this.name, name, name);
            throw new OSchemaException(error);
        }
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in view name '" + name + "'");
        }
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter view `%s` name `%s`", this.name, name);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView setShortName(String shortName) {
        if (shortName != null && (shortName = shortName.trim()).isEmpty()) {
            shortName = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter view `%s` shortname `%s`", this.name, shortName);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected OPropertyImpl createPropertyInstance(ODocument p) {
        return new OPropertyRemote((OClassImpl)this, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView truncateCluster(String clusterName) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)this.name);
        this.acquireSchemaReadLock();
        try {
            String cmd = String.format("truncate cluster %s", clusterName);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaReadLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView setStrictMode(boolean isStrict) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter view `%s` strictmode %s", this.name, isStrict);
            database.command(cmd, new Object[0]);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView setDescription(String iDescription) {
        if (iDescription != null && (iDescription = iDescription.trim()).isEmpty()) {
            iDescription = null;
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter view `%s` description ?", this.name);
            database.command(cmd, new Object[]{iDescription}).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public OView addClusterId(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public OView removeClusterId(int clusterId) {
        throw new UnsupportedOperationException();
    }

    public void dropProperty(String propertyName) {
        ODatabaseDocumentInternal database = this.getDatabase();
        if (database.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (!this.properties.containsKey(propertyName)) {
                throw new OSchemaException("Property '" + propertyName + "' not found in class " + this.name + "'");
            }
            database.command("drop property " + this.name + '.' + propertyName, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public OView addCluster(String clusterNameOrId) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OView setOverSize(float overSize) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter view `%s` oversize %s", this.name, new Float(overSize).toString());
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public OView setAbstract(boolean isAbstract) {
        throw new UnsupportedOperationException();
    }

    protected OView removeBaseClassInternal(OClass baseClass) {
        throw new UnsupportedOperationException();
    }

    protected void setSuperClassesInternal(List<? extends OClass> classes) {
        throw new UnsupportedOperationException();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        throw new UnsupportedOperationException();
    }
}

