/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityExternal;
import com.orientechnologies.orient.core.metadata.security.OSystemUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OAuditingOperation;
import com.orientechnologies.orient.core.security.OInvalidPasswordException;
import com.orientechnologies.orient.core.security.OSecurityFactory;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.security.OSecuritySystemException;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.config.OServerConfigurationManager;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.plugin.OServerPluginInfo;
import com.orientechnologies.orient.server.security.OAuditingService;
import com.orientechnologies.orient.server.security.OPasswordValidator;
import com.orientechnologies.orient.server.security.OSecurityAuthenticator;
import com.orientechnologies.orient.server.security.OSecurityComponent;
import com.orientechnologies.orient.server.security.OServerSecurity;
import com.orientechnologies.orient.server.security.OSyslog;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class ODefaultServerSecurity
implements OSecurityFactory,
OServerLifecycleListener,
OServerSecurity {
    private boolean enabled = false;
    private boolean debug = false;
    private boolean storePasswords = true;
    private boolean allowDefault = true;
    private final Object passwordValidatorSynch = new Object();
    private OPasswordValidator passwordValidator;
    private final Object importLDAPSynch = new Object();
    private OSecurityComponent importLDAP;
    private final Object auditingSynch = new Object();
    private OAuditingService auditingService;
    private ODocument configDoc;
    private OServer server;
    private OServerConfigurationManager serverConfig;
    private ODocument auditingDoc;
    private ODocument serverDoc;
    private ODocument authDoc;
    private ODocument passwdValDoc;
    private ODocument ldapImportDoc;
    private final String superUser = "OSecurityModuleSuperUser";
    private String superUserPassword;
    private OServerUserConfiguration superUserCfg;
    private final List<OSecurityAuthenticator> authenticatorsList = new ArrayList<OSecurityAuthenticator>();
    private ConcurrentHashMap<String, Class<?>> securityClassMap = new ConcurrentHashMap();
    private OSyslog sysLog;

    public ODefaultServerSecurity(OServer oServer, OServerConfigurationManager serverCfg) {
        this.server = oServer;
        this.serverConfig = serverCfg;
        oServer.registerLifecycleListener(this);
        OSecurityManager.instance().setSecurityFactory((OSecurityFactory)this);
    }

    public void shutdown() {
        this.server.unregisterLifecycleListener(this);
    }

    private Class<?> getClass(ODocument jsonConfig) {
        Class<?> cls = null;
        try {
            if (jsonConfig.containsField("class")) {
                String clsName = (String)jsonConfig.field("class");
                cls = this.securityClassMap.containsKey(clsName) ? this.securityClassMap.get(clsName) : Class.forName(clsName);
            }
        }
        catch (Throwable th) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getClass() Throwable: ", th, new Object[0]);
        }
        return cls;
    }

    public boolean isDefaultAllowed() {
        if (this.isEnabled()) {
            return this.allowDefault;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String authenticate(String username, String password) {
        try {
            if (username != null && !username.isEmpty()) {
                if (this.debug) {
                    OLogManager.instance().info((Object)this, "ODefaultServerSecurity.authenticate() ** Authenticating username: %s", new Object[]{username});
                }
                if (username.equals("OSecurityModuleSuperUser") && password.equals(this.superUserPassword)) {
                    return "OSecurityModuleSuperUser";
                }
            }
            List<OSecurityAuthenticator> list = this.authenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this.authenticatorsList) {
                    String principal;
                    if (!sa.isEnabled() || (principal = sa.authenticate(username, password)) == null) continue;
                    return principal;
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.authenticate() Exception: %s", new Object[]{ex.getMessage()});
        }
        return null;
    }

    protected OServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthenticationHeader(String databaseName) {
        String header = null;
        header = databaseName != null ? "WWW-Authenticate: Basic realm=\"OrientDB db-" + databaseName + "\"" : "WWW-Authenticate: Basic realm=\"OrientDB Server\"";
        if (this.isEnabled()) {
            List<OSecurityAuthenticator> list = this.authenticatorsList;
            synchronized (list) {
                StringBuilder sb = new StringBuilder();
                for (OSecurityAuthenticator sa : this.authenticatorsList) {
                    String sah;
                    if (!sa.isEnabled() || (sah = sa.getAuthenticationHeader(databaseName)) == null || sah.trim().length() <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(sah);
                }
                if (sb.length() > 0) {
                    header = sb.toString();
                }
            }
        }
        return header;
    }

    public ODocument getConfig() {
        ODocument jsonConfig = new ODocument();
        try {
            jsonConfig.field("enabled", (Object)this.enabled);
            jsonConfig.field("debug", (Object)this.debug);
            if (this.serverDoc != null) {
                jsonConfig.field("server", (Object)this.serverDoc, new OType[]{OType.EMBEDDED});
            }
            if (this.authDoc != null) {
                jsonConfig.field("authentication", (Object)this.authDoc, new OType[]{OType.EMBEDDED});
            }
            if (this.passwdValDoc != null) {
                jsonConfig.field("passwordValidator", (Object)this.passwdValDoc, new OType[]{OType.EMBEDDED});
            }
            if (this.ldapImportDoc != null) {
                jsonConfig.field("ldapImporter", (Object)this.ldapImportDoc, new OType[]{OType.EMBEDDED});
            }
            if (this.auditingDoc != null) {
                jsonConfig.field("auditing", (Object)this.auditingDoc, new OType[]{OType.EMBEDDED});
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getConfig() Exception: %s", (Throwable)ex, new Object[0]);
        }
        return jsonConfig;
    }

    public ODocument getComponentConfig(String name) {
        if (name != null) {
            if (name.equalsIgnoreCase("auditing")) {
                return this.auditingDoc;
            }
            if (name.equalsIgnoreCase("authentication")) {
                return this.authDoc;
            }
            if (name.equalsIgnoreCase("ldapImporter")) {
                return this.ldapImportDoc;
            }
            if (name.equalsIgnoreCase("passwordValidator")) {
                return this.passwdValDoc;
            }
            if (name.equalsIgnoreCase("server")) {
                return this.serverDoc;
            }
        }
        return null;
    }

    public OUser getSystemUser(String username, final String dbName) {
        if (this.isEnabled()) {
            return (OUser)this.server.getSystemDatabase().execute(new OCallable<Object, Object>(){

                public Object call(Object iArgument) {
                    List result = (List)iArgument;
                    if (result != null && !result.isEmpty()) {
                        return new OSystemUser((ODocument)result.get(0), dbName);
                    }
                    return null;
                }
            }, "select from OUser where name = ? limit 1 fetchplan roles:1", username);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthorized(String username, String resource) {
        if (this.isEnabled()) {
            if (username == null || resource == null) {
                return false;
            }
            if (username.equals("OSecurityModuleSuperUser")) {
                return true;
            }
            List<OSecurityAuthenticator> list = this.authenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this.authenticatorsList) {
                    if (!sa.isEnabled() || !sa.isAuthorized(username, resource)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean arePasswordsStored() {
        if (this.isEnabled()) {
            return this.storePasswords;
        }
        return true;
    }

    public boolean isSingleSignOnSupported() {
        OSecurityAuthenticator priAuth;
        if (this.isEnabled() && (priAuth = this.getPrimaryAuthenticator()) != null) {
            return priAuth.isSingleSignOnSupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePassword(String password) throws OInvalidPasswordException {
        if (this.isEnabled()) {
            Object object = this.passwordValidatorSynch;
            synchronized (object) {
                if (this.passwordValidator != null) {
                    this.passwordValidator.validatePassword(password);
                }
            }
        }
    }

    @Override
    public OAuditingService getAuditing() {
        return this.auditingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSecurityAuthenticator getAuthenticator(String authMethod) {
        if (this.isEnabled()) {
            List<OSecurityAuthenticator> list = this.authenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator am : this.authenticatorsList) {
                    if (authMethod == null || authMethod.isEmpty()) {
                        return am;
                    }
                    if (am.getName() == null || !am.getName().equalsIgnoreCase(authMethod)) continue;
                    return am;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSecurityAuthenticator getPrimaryAuthenticator() {
        if (this.isEnabled()) {
            List<OSecurityAuthenticator> list = this.authenticatorsList;
            synchronized (list) {
                if (this.authenticatorsList.size() > 0) {
                    return this.authenticatorsList.get(0);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OServerUserConfiguration getUser(String username) {
        OServerUserConfiguration userCfg = null;
        if (this.isEnabled()) {
            if (username.equals("OSecurityModuleSuperUser")) {
                return this.superUserCfg;
            }
            List<OSecurityAuthenticator> list = this.authenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this.authenticatorsList) {
                    if (sa.isEnabled() && (userCfg = sa.getUser(username)) != null) break;
                }
            }
        }
        return userCfg;
    }

    @Override
    public ODatabase<?> openDatabase(String dbName) {
        ODatabaseDocumentTx db = null;
        if (this.isEnabled()) {
            db = this.server.openDatabase(dbName, "OSecurityModuleSuperUser", "", null, true);
        }
        return db;
    }

    @Override
    public OSyslog getSyslog() {
        OServerPluginInfo syslogPlugin;
        if (this.sysLog == null && (syslogPlugin = this.server.getPluginManager().getPluginByName("syslog")) != null) {
            this.sysLog = (OSyslog)((Object)syslogPlugin.getInstance());
        }
        return this.sysLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(OAuditingOperation operation, String dbName, String username, String message) {
        Object object = this.auditingSynch;
        synchronized (object) {
            if (this.auditingService != null) {
                this.auditingService.log(operation, dbName, username, message);
            }
        }
    }

    public void registerSecurityClass(Class<?> cls) {
        String fullTypeName = ODefaultServerSecurity.getFullTypeName(cls);
        if (fullTypeName != null) {
            this.securityClassMap.put(fullTypeName, cls);
        }
    }

    public void unregisterSecurityClass(Class<?> cls) {
        String fullTypeName = ODefaultServerSecurity.getFullTypeName(cls);
        if (fullTypeName != null) {
            this.securityClassMap.remove(fullTypeName);
        }
    }

    private static String getFullTypeName(Class<?> type) {
        String typeName = null;
        typeName = type.getSimpleName();
        Package pack = type.getPackage();
        if (pack != null) {
            typeName = pack.getName() + "." + typeName;
        }
        return typeName;
    }

    public void reload(String cfgPath) {
        this.reload(this.loadConfig(cfgPath));
    }

    public void reload(ODocument configDoc) {
        if (configDoc == null) {
            OLogManager.instance().warn((Object)this, "ODefaultServerSecurity.reload(ODocument) The provided configuration document is null", new Object[0]);
            throw new OSecuritySystemException("ODefaultServerSecurity.reload(ODocument) The provided configuration document is null");
        }
        this.onBeforeDeactivate();
        this.configDoc = configDoc;
        this.onAfterDynamicPlugins();
        this.log(OAuditingOperation.RELOADEDSECURITY, null, null, "The security configuration file has been reloaded");
    }

    public void reloadComponent(String name, ODocument jsonConfig) {
        if (name == null || name.isEmpty()) {
            throw new OSecuritySystemException("ODefaultServerSecurity.reloadComponent() name is null or empty");
        }
        if (jsonConfig == null) {
            throw new OSecuritySystemException("ODefaultServerSecurity.reloadComponent() Configuration document is null");
        }
        if (name.equalsIgnoreCase("auditing")) {
            this.auditingDoc = jsonConfig;
            this.reloadAuditingService();
        } else if (name.equalsIgnoreCase("authentication")) {
            this.authDoc = jsonConfig;
            this.reloadAuthMethods();
        } else if (name.equalsIgnoreCase("ldapImporter")) {
            this.ldapImportDoc = jsonConfig;
            this.reloadImportLDAP();
        } else if (name.equalsIgnoreCase("passwordValidator")) {
            this.passwdValDoc = jsonConfig;
            this.reloadPasswordValidator();
        } else if (name.equalsIgnoreCase("server")) {
            this.serverDoc = jsonConfig;
            this.reloadServer();
        }
        this.setSection(name, jsonConfig);
        this.log(OAuditingOperation.RELOADEDSECURITY, null, null, String.format("The %s security component has been reloaded", name));
    }

    public void securityRecordChange(final String dbURL, ODocument record) {
        Orient.instance().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OClientConnectionManager ccm = ODefaultServerSecurity.this.server.getClientConnectionManager();
                    if (ccm != null) {
                        for (OClientConnection cc : ccm.getConnections()) {
                            try {
                                cc.acquire();
                                ODatabaseDocumentInternal ccDB = cc.getDatabase();
                                if (ccDB == null) continue;
                                ccDB.activateOnCurrentThread();
                                if (ccDB.isClosed() || ccDB.getURL() == null || !ccDB.getURL().equals(dbURL)) continue;
                                ccDB.reloadUser();
                            }
                            catch (Exception ex) {
                                OLogManager.instance().error((Object)this, "securityRecordChange() Exception: ", (Throwable)ex, new Object[0]);
                            }
                            finally {
                                cc.release();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    OLogManager.instance().error((Object)this, "securityRecordChange() Exception: ", (Throwable)ex, new Object[0]);
                }
                ODatabaseRecordThreadLocal.INSTANCE.remove();
            }
        });
    }

    private void createSuperUser() {
        if ("OSecurityModuleSuperUser" == null) {
            throw new OSecuritySystemException("ODefaultServerSecurity.createSuperUser() SuperUser cannot be null");
        }
        try {
            this.superUserPassword = OSecurityManager.instance().createSHA256(String.valueOf(new Random().nextLong()));
            this.superUserCfg = new OServerUserConfiguration("OSecurityModuleSuperUser", this.superUserPassword, "*");
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "createSuperUser() Exception: ", (Throwable)ex, new Object[0]);
        }
        if (this.superUserPassword == null) {
            throw new OSecuritySystemException("ODefaultServerSecurity Could not create SuperUser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAuthenticators(ODocument authDoc) {
        List<OSecurityAuthenticator> list = this.authenticatorsList;
        synchronized (list) {
            for (OSecurityAuthenticator sa : this.authenticatorsList) {
                sa.dispose();
            }
            this.authenticatorsList.clear();
            if (authDoc.containsField("authenticators")) {
                List authMethodsList = (List)authDoc.field("authenticators");
                for (ODocument authMethodDoc : authMethodsList) {
                    try {
                        if (authMethodDoc.containsField("name")) {
                            String name = (String)authMethodDoc.field("name");
                            boolean enabled = true;
                            if (authMethodDoc.containsField("enabled")) {
                                enabled = (Boolean)authMethodDoc.field("enabled");
                            }
                            if (!enabled) continue;
                            Class<?> authClass = this.getClass(authMethodDoc);
                            if (authClass != null) {
                                if (OSecurityAuthenticator.class.isAssignableFrom(authClass)) {
                                    OSecurityAuthenticator authPlugin = (OSecurityAuthenticator)authClass.newInstance();
                                    authPlugin.config(this.server, this.serverConfig, authMethodDoc);
                                    authPlugin.active();
                                    this.authenticatorsList.add(authPlugin);
                                    continue;
                                }
                                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() class is not an OSecurityAuthenticator", new Object[0]);
                                continue;
                            }
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() authentication class is null for %s", new Object[]{name});
                            continue;
                        }
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() authentication object is missing name", new Object[0]);
                    }
                    catch (Throwable ex) {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadAuthenticators() Exception: ", ex, new Object[0]);
                    }
                }
            }
        }
    }

    @Override
    public void onBeforeActivate() {
        String ssf;
        this.createSuperUser();
        String configFile = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/security.json");
        String securityFile = this.getConfigProperty("server.security.file");
        if (securityFile != null) {
            configFile = securityFile;
        }
        if ((ssf = OGlobalConfiguration.SERVER_SECURITY_FILE.getValueAsString()) != null) {
            configFile = ssf;
        }
        this.configDoc = this.loadConfig(configFile);
    }

    @Override
    public void onAfterActivate() {
    }

    @Override
    public void onAfterDynamicPlugins() {
        if (this.configDoc != null) {
            this.loadComponents();
            if (this.isEnabled()) {
                this.registerRESTCommands();
                this.log(OAuditingOperation.SECURITY, null, null, "The security module is now loaded");
            }
        } else {
            OLogManager.instance().warn((Object)this, "onAfterDynamicPlugins() Configuration document is empty", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeDeactivate() {
        if (this.enabled) {
            this.unregisterRESTCommands();
            List<OSecurityAuthenticator> list = this.importLDAPSynch;
            synchronized (list) {
                if (this.importLDAP != null) {
                    this.importLDAP.dispose();
                    this.importLDAP = null;
                }
            }
            list = this.passwordValidatorSynch;
            synchronized (list) {
                if (this.passwordValidator != null) {
                    this.passwordValidator.dispose();
                    this.passwordValidator = null;
                }
            }
            list = this.auditingSynch;
            synchronized (list) {
                if (this.auditingService != null) {
                    this.auditingService.dispose();
                    this.auditingService = null;
                }
            }
            list = this.authenticatorsList;
            synchronized (list) {
                for (OSecurityAuthenticator sa : this.authenticatorsList) {
                    sa.dispose();
                }
                this.authenticatorsList.clear();
            }
            this.enabled = false;
        }
    }

    @Override
    public void onAfterDeactivate() {
    }

    protected void loadComponents() {
        this.loadSecurity();
        if (this.isEnabled()) {
            this.auditingDoc = this.getSection("auditing");
            this.reloadAuditingService();
            this.serverDoc = this.getSection("server");
            this.reloadServer();
            this.authDoc = this.getSection("authentication");
            this.reloadAuthMethods();
            this.passwdValDoc = this.getSection("passwordValidator");
            this.reloadPasswordValidator();
            this.ldapImportDoc = this.getSection("ldapImporter");
            this.reloadImportLDAP();
        }
    }

    private ODocument getSection(String section) {
        ODocument sectionDoc = null;
        try {
            if (this.configDoc != null) {
                if (this.configDoc.containsField(section)) {
                    sectionDoc = (ODocument)this.configDoc.field(section);
                }
            } else {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getSection(%s) Configuration document is null", new Object[]{section});
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.getSection(%s) Exception: %s", new Object[]{section, ex.getMessage()});
        }
        return sectionDoc;
    }

    private void setSection(String section, ODocument sectionDoc) {
        ODocument oldSection = this.getSection(section);
        try {
            if (this.configDoc != null) {
                String ssf;
                this.configDoc.field(section, (Object)sectionDoc);
                String configFile = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/security.json");
                String securityFile = this.getConfigProperty("server.security.file");
                if (securityFile != null) {
                    configFile = securityFile;
                }
                if ((ssf = OGlobalConfiguration.SERVER_SECURITY_FILE.getValueAsString()) != null) {
                    configFile = ssf;
                }
                File f = new File(configFile);
                OIOUtils.writeFile((File)f, (String)this.configDoc.toJSON("prettyPrint"));
            }
        }
        catch (Exception ex) {
            this.configDoc.field(section, (Object)oldSection);
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.setSection(%s) Exception: %s", new Object[]{section, ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ODocument loadConfig(String cfgPath) {
        ODocument securityDoc;
        block8: {
            securityDoc = null;
            try {
                if (cfgPath != null) {
                    String jsonFile = OSystemVariableResolver.resolveSystemVariables((String)cfgPath);
                    File file = new File(jsonFile);
                    if (file.exists() && file.canRead()) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(file);
                            byte[] buffer = new byte[(int)file.length()];
                            fis.read(buffer);
                            securityDoc = new ODocument().fromJSON(new String(buffer), "noMap");
                            break block8;
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadConfig() Could not access the security JSON file: %s", new Object[]{jsonFile});
                    break block8;
                }
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadConfig() Configuration file path is null", new Object[0]);
            }
            catch (Exception ex) {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadConfig() Exception: %s", new Object[]{ex.getMessage()});
            }
        }
        return securityDoc;
    }

    protected String getConfigProperty(String name) {
        String value = null;
        if (this.server.getConfiguration() != null && this.server.getConfiguration().properties != null) {
            for (OServerEntryConfiguration p : this.server.getConfiguration().properties) {
                if (!p.name.equals(name)) continue;
                value = OSystemVariableResolver.resolveSystemVariables((String)p.value);
                break;
            }
        }
        return value;
    }

    private boolean isEnabled(ODocument sectionDoc) {
        boolean enabled = true;
        try {
            if (sectionDoc.containsField("enabled")) {
                enabled = (Boolean)sectionDoc.field("enabled");
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.isEnabled() Exception: %s", new Object[]{ex.getMessage()});
        }
        return enabled;
    }

    private void loadSecurity() {
        try {
            this.enabled = false;
            if (this.configDoc != null) {
                if (this.configDoc.containsField("enabled")) {
                    this.enabled = (Boolean)this.configDoc.field("enabled");
                }
                if (this.configDoc.containsField("debug")) {
                    this.debug = (Boolean)this.configDoc.field("debug");
                }
            } else {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadSecurity() jsonConfig is null", new Object[0]);
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadSecurity() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    private void reloadServer() {
        try {
            this.storePasswords = true;
            if (this.serverDoc != null) {
                if (this.serverDoc.containsField("createDefaultUsers")) {
                    OGlobalConfiguration.CREATE_DEFAULT_USERS.setValue(this.serverDoc.field("createDefaultUsers"));
                }
                if (this.serverDoc.containsField("storePasswords")) {
                    this.storePasswords = (Boolean)this.serverDoc.field("storePasswords");
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.loadServer() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    private void reloadAuthMethods() {
        if (this.authDoc != null) {
            if (this.authDoc.containsField("allowDefault")) {
                this.allowDefault = (Boolean)this.authDoc.field("allowDefault");
            }
            this.loadAuthenticators(this.authDoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPasswordValidator() {
        try {
            Object object = this.passwordValidatorSynch;
            synchronized (object) {
                if (this.passwordValidator != null) {
                    this.passwordValidator.dispose();
                    this.passwordValidator = null;
                }
                if (this.passwdValDoc != null && this.isEnabled(this.passwdValDoc)) {
                    Class<?> cls = this.getClass(this.passwdValDoc);
                    if (cls != null) {
                        if (OPasswordValidator.class.isAssignableFrom(cls)) {
                            this.passwordValidator = (OPasswordValidator)cls.newInstance();
                            this.passwordValidator.config(this.server, this.serverConfig, this.passwdValDoc);
                            this.passwordValidator.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadPasswordValidator() class is not an OPasswordValidator", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadPasswordValidator() PasswordValidator class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadPasswordValidator() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadImportLDAP() {
        try {
            Object object = this.importLDAPSynch;
            synchronized (object) {
                if (this.importLDAP != null) {
                    this.importLDAP.dispose();
                    this.importLDAP = null;
                }
                if (this.ldapImportDoc != null && this.isEnabled(this.ldapImportDoc)) {
                    Class<?> cls = this.getClass(this.ldapImportDoc);
                    if (cls != null) {
                        if (OSecurityComponent.class.isAssignableFrom(cls)) {
                            this.importLDAP = (OSecurityComponent)cls.newInstance();
                            this.importLDAP.config(this.server, this.serverConfig, this.ldapImportDoc);
                            this.importLDAP.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadImportLDAP() class is not an OSecurityComponent", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadImportLDAP() ImportLDAP class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadImportLDAP() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadAuditingService() {
        try {
            Object object = this.auditingSynch;
            synchronized (object) {
                if (this.auditingService != null) {
                    this.auditingService.dispose();
                    this.auditingService = null;
                }
                if (this.auditingDoc != null && this.isEnabled(this.auditingDoc)) {
                    Class<?> cls = this.getClass(this.auditingDoc);
                    if (cls != null) {
                        if (OAuditingService.class.isAssignableFrom(cls)) {
                            this.auditingService = (OAuditingService)cls.newInstance();
                            this.auditingService.config(this.server, this.serverConfig, this.auditingDoc);
                            this.auditingService.active();
                        } else {
                            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadAuditingService() class is not an OAuditingService", new Object[0]);
                        }
                    } else {
                        OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadAuditingService() Auditing class property is missing", new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.reloadAuditingService() Exception: %s", new Object[]{ex.getMessage()});
        }
    }

    public OSecurity newSecurity() {
        return new OSecurityExternal();
    }

    private void registerRESTCommands() {
        try {
            Object listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
            if (listener == null) {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.registerRESTCommands() unable to retrieve Network Protocol listener.", new Object[0]);
            }
        }
        catch (Throwable th) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.registerRESTCommands() Throwable: " + th.getMessage(), new Object[0]);
        }
    }

    private void unregisterRESTCommands() {
        try {
            Object listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
            if (listener == null) {
                OLogManager.instance().error((Object)this, "ODefaultServerSecurity.unregisterRESTCommands() unable to retrieve Network Protocol listener.", new Object[0]);
            }
        }
        catch (Throwable th) {
            OLogManager.instance().error((Object)this, "ODefaultServerSecurity.unregisterRESTCommands() Throwable: " + th.getMessage(), new Object[0]);
        }
    }
}

