/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.palantir.gradle.gitversion.RefWithTagName;
import java.io.IOException;
import java.time.Instant;
import java.util.Comparator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

class RefWithTagNameComparator
implements Comparator<RefWithTagName> {
    private final RevWalk walk;

    RefWithTagNameComparator(Git git) {
        this.walk = new RevWalk(git.getRepository());
    }

    @Override
    public int compare(RefWithTagName tag1, RefWithTagName tag2) {
        boolean isTag1Annotated = RefWithTagNameComparator.isAnnotatedTag(tag1.getRef());
        boolean isTag2Annotated = RefWithTagNameComparator.isAnnotatedTag(tag2.getRef());
        if (isTag1Annotated && !isTag2Annotated) {
            return -1;
        }
        if (!isTag1Annotated && isTag2Annotated) {
            return 1;
        }
        if (!isTag1Annotated && !isTag2Annotated) {
            return tag1.getRef().getName().compareTo(tag2.getRef().getName());
        }
        Instant timeTag1 = this.getAnnotatedTagDate(tag1.getRef());
        Instant timeTag2 = this.getAnnotatedTagDate(tag2.getRef());
        if (timeTag1 != null && timeTag2 != null) {
            return timeTag2.compareTo(timeTag1);
        }
        return tag1.getRef().getName().compareTo(tag2.getRef().getName());
    }

    private Instant getAnnotatedTagDate(Ref ref) {
        try {
            RevTag tag = this.walk.parseTag((AnyObjectId)ref.getObjectId());
            PersonIdent identity = tag.getTaggerIdent();
            return identity.getWhen().toInstant();
        }
        catch (IOException | RuntimeException ignored) {
            return null;
        }
    }

    private static boolean isAnnotatedTag(Ref ref) {
        ObjectId peeledObjectId = ref.getPeeledObjectId();
        return peeledObjectId != null;
    }
}

