/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.collect.ImmutableMap;
import com.palantir.gradle.gitversion.BuildScanPluginInterop;
import com.palantir.gradle.gitversion.GitVersionCacheService;
import com.palantir.gradle.gitversion.Timer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;

final class GitVersionRootPlugin
implements Plugin<Project> {
    GitVersionRootPlugin() {
    }

    public void apply(Project project) {
        if (project.getRootProject() != project) {
            throw new IllegalStateException(String.format("The %s plugin must be applied to the root project", GitVersionRootPlugin.class.getSimpleName()));
        }
        Provider<GitVersionCacheService> serviceProvider = GitVersionCacheService.getSharedGitVersionCacheService(project);
        BuildScanPluginInterop.addBuildScanCustomValues(project, () -> {
            Timer timer = ((GitVersionCacheService)serviceProvider.get()).timer();
            String timerJson = timer.toJson();
            long totalTime = timer.totalMillis();
            return ImmutableMap.of((Object)"com.palantir.git-version.timings", (Object)timerJson, (Object)"com.palantir.git-version.timings.total", (Object)Long.toString(totalTime));
        });
    }
}

