/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.base.Preconditions;
import com.palantir.gradle.gitversion.Git;
import com.palantir.gradle.gitversion.GitVersionArgs;
import com.palantir.gradle.gitversion.VersionDetails;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VersionDetailsImpl
implements VersionDetails {
    private static final Logger log = LoggerFactory.getLogger(VersionDetailsImpl.class);
    private static final int VERSION_ABBR_LENGTH = 10;
    private static final String DOT_GIT_DIR_PATH = "/.git";
    private final GitVersionArgs args;
    private Git nativeGitInvoker;

    VersionDetailsImpl(File gitDir, GitVersionArgs args) {
        String gitDirStr = gitDir.toString();
        String projectDir = gitDirStr.substring(0, gitDirStr.length() - DOT_GIT_DIR_PATH.length());
        this.nativeGitInvoker = new Git(new File(projectDir));
        this.args = args;
    }

    @Override
    public String getVersion() {
        if (this.description() == null) {
            return "unspecified";
        }
        return this.description() + (this.isClean() ? "" : ".dirty");
    }

    private boolean isClean() {
        return this.nativeGitInvoker.isClean();
    }

    private String description() {
        String rawDescription = this.nativeGitInvoker.describe(this.args.getPrefix());
        String processedDescription = rawDescription == null ? null : rawDescription.replaceFirst("^" + this.args.getPrefix(), "");
        return processedDescription;
    }

    @Override
    public boolean getIsCleanTag() {
        return this.isClean() && this.descriptionIsPlainTag();
    }

    private boolean descriptionIsPlainTag() {
        return !Pattern.matches(".*g.?[0-9a-fA-F]{3,}", this.description());
    }

    @Override
    public int getCommitDistance() {
        if (this.descriptionIsPlainTag()) {
            return 0;
        }
        Matcher match = Pattern.compile("(.*)-([0-9]+)-g.?[0-9a-fA-F]{3,}").matcher(this.description());
        Preconditions.checkState((boolean)match.matches(), (String)"Cannot get commit distance for description: '%s'", (Object)this.description());
        return Integer.parseInt(match.group(2));
    }

    @Override
    public String getLastTag() {
        if (this.descriptionIsPlainTag()) {
            return this.description();
        }
        Matcher match = Pattern.compile("(.*)-([0-9]+)-g.?[0-9a-fA-F]{3,}").matcher(this.description());
        return match.matches() ? match.group(1) : null;
    }

    @Override
    public String getGitHash() throws IOException {
        String gitHashFull = this.getGitHashFull();
        if (gitHashFull == null) {
            return null;
        }
        return gitHashFull.substring(0, 10);
    }

    @Override
    public String getGitHashFull() throws IOException {
        return this.nativeGitInvoker.getCurrentHeadFullHash();
    }

    @Override
    public String getBranchName() throws IOException {
        return this.nativeGitInvoker.getCurrentBranch();
    }

    public String toString() {
        try {
            return String.format("VersionDetails(%s, %s, %s, %s, %s)", this.getVersion(), this.getGitHash(), this.getGitHashFull(), this.getBranchName(), this.getIsCleanTag());
        }
        catch (IOException e) {
            return "";
        }
    }
}

