/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ExecOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Git {
    private static final Logger log = LoggerFactory.getLogger(Git.class);
    private final File repositoryDir;
    private final ProviderFactory providerFactory;

    Git(File repositoryDir, ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.repositoryDir = repositoryDir;
    }

    public Provider<String> run(Map<String, String> envvars, String ... commands) {
        ExecOutput output = this.providerFactory.exec(execSpec -> {
            execSpec.executable((Object)"git");
            execSpec.args((Object[])commands);
            execSpec.environment(envvars);
            execSpec.workingDir((Object)this.repositoryDir);
            execSpec.setIgnoreExitValue(true);
        });
        return output.getResult().flatMap(execResult -> {
            if (execResult.getExitValue() != 0) {
                String stdErr = (String)output.getStandardError().getAsText().get();
                String errorMsg = String.format("git command failed: %s", stdErr);
                log.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            return output.getStandardOutput().getAsText().map(String::trim);
        });
    }

    public Provider<String> run(String ... command) {
        return this.run(new HashMap<String, String>(), command);
    }
}

