/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.palantir.gradle.gitversion.GitVersionCacheService;
import com.palantir.gradle.gitversion.GitVersionRootPlugin;
import com.palantir.gradle.gitversion.VersionDetails;
import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;

public final class GitVersionPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getRootProject().getPluginManager().apply(GitVersionRootPlugin.class);
        final Provider<GitVersionCacheService> serviceProvider = GitVersionCacheService.getSharedGitVersionCacheService(project);
        project.getExtensions().getExtraProperties().set("gitVersion", (Object)new Closure<String>((Object)this, (Object)this){

            public String doCall(Object args) {
                return ((GitVersionCacheService)serviceProvider.get()).getGitVersion(project.getProjectDir(), args);
            }
        });
        project.getExtensions().getExtraProperties().set("versionDetails", (Object)new Closure<VersionDetails>((Object)this, (Object)this){

            public VersionDetails doCall(Object args) {
                return ((GitVersionCacheService)serviceProvider.get()).getVersionDetails(project.getProjectDir(), args);
            }
        });
        project.getTasks().register("printVersion", task -> {
            task.doLast((Action)new Action<Task>(){

                public void execute(Task _task) {
                    System.out.println(project.getVersion());
                }
            });
            task.setGroup("Versioning");
            task.setDescription("Prints the project's configured version to standard out");
        });
    }
}

