/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.palantir.javaformat.BreakBehaviour;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class BreakBehaviours {
    private static BreakBehaviour breakThisLevel;
    private static BreakBehaviour inlineSuffix;
    private static final BreakBehaviour.Cases<Optional<Boolean>> keepIndentWhenInlinedGetter;

    private BreakBehaviours() {
    }

    public static <R> BreakBehaviour.Cases<R> cases(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix, Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
        return new LambdaCases<R>(breakThisLevel, preferBreakingLastInnerLevel, inlineSuffix, breakOnlyIfInnerLevelsThenFitOnOneLine);
    }

    public static BreakBehaviour breakThisLevel() {
        BreakBehaviour _breakThisLevel = breakThisLevel;
        if (_breakThisLevel == null) {
            breakThisLevel = _breakThisLevel = new BreakThisLevel();
        }
        return _breakThisLevel;
    }

    public static BreakBehaviour preferBreakingLastInnerLevel(boolean keepIndentWhenInlined) {
        return new PreferBreakingLastInnerLevel(keepIndentWhenInlined);
    }

    public static BreakBehaviour inlineSuffix() {
        BreakBehaviour _inlineSuffix = inlineSuffix;
        if (_inlineSuffix == null) {
            inlineSuffix = _inlineSuffix = new InlineSuffix();
        }
        return _inlineSuffix;
    }

    public static BreakBehaviour breakOnlyIfInnerLevelsThenFitOnOneLine(boolean keepIndentWhenInlined) {
        return new BreakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined);
    }

    public static BreakBehaviour lazy(Supplier<BreakBehaviour> breakBehaviour) {
        return new Lazy(breakBehaviour);
    }

    public static CasesMatchers.TotalMatcher_BreakThisLevel cases() {
        return CasesMatchers.totalMatcher_BreakThisLevel;
    }

    public static CaseOfMatchers.TotalMatcher_BreakThisLevel caseOf(BreakBehaviour breakBehaviour) {
        return new CaseOfMatchers.TotalMatcher_BreakThisLevel(breakBehaviour);
    }

    public static Optional<Boolean> getKeepIndentWhenInlined(BreakBehaviour breakBehaviour) {
        return breakBehaviour.match(keepIndentWhenInlinedGetter);
    }

    public static Function<BreakBehaviour, BreakBehaviour> setKeepIndentWhenInlined(Boolean newKeepIndentWhenInlined) {
        return BreakBehaviours.modKeepIndentWhenInlined(__ -> newKeepIndentWhenInlined);
    }

    public static Function<BreakBehaviour, BreakBehaviour> modKeepIndentWhenInlined(Function<Boolean, Boolean> keepIndentWhenInlinedMod) {
        BreakBehaviour.Cases<BreakBehaviour> cases = BreakBehaviours.cases(BreakBehaviours::breakThisLevel, keepIndentWhenInlined -> BreakBehaviours.preferBreakingLastInnerLevel((Boolean)keepIndentWhenInlinedMod.apply((Boolean)keepIndentWhenInlined)), BreakBehaviours::inlineSuffix, keepIndentWhenInlined -> BreakBehaviours.breakOnlyIfInnerLevelsThenFitOnOneLine((Boolean)keepIndentWhenInlinedMod.apply((Boolean)keepIndentWhenInlined)));
        return breakBehaviour -> (BreakBehaviour)breakBehaviour.match(cases);
    }

    static {
        keepIndentWhenInlinedGetter = BreakBehaviours.cases(() -> Optional.empty(), keepIndentWhenInlined -> Optional.of(keepIndentWhenInlined), () -> Optional.empty(), keepIndentWhenInlined -> Optional.of(keepIndentWhenInlined));
    }

    private static final class LambdaCases<R>
    implements BreakBehaviour.Cases<R> {
        private final Supplier<R> breakThisLevel;
        private final Function<Boolean, R> preferBreakingLastInnerLevel;
        private final Supplier<R> inlineSuffix;
        private final Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine;

        LambdaCases(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix, Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
            this.breakThisLevel = breakThisLevel;
            this.preferBreakingLastInnerLevel = preferBreakingLastInnerLevel;
            this.inlineSuffix = inlineSuffix;
            this.breakOnlyIfInnerLevelsThenFitOnOneLine = breakOnlyIfInnerLevelsThenFitOnOneLine;
        }

        @Override
        public R breakThisLevel() {
            return this.breakThisLevel.get();
        }

        @Override
        public R preferBreakingLastInnerLevel(boolean keepIndentWhenInlined) {
            return this.preferBreakingLastInnerLevel.apply(keepIndentWhenInlined);
        }

        @Override
        public R inlineSuffix() {
            return this.inlineSuffix.get();
        }

        @Override
        public R breakOnlyIfInnerLevelsThenFitOnOneLine(boolean keepIndentWhenInlined) {
            return this.breakOnlyIfInnerLevelsThenFitOnOneLine.apply(keepIndentWhenInlined);
        }
    }

    private static final class BreakThisLevel
    extends BreakBehaviour {
        BreakThisLevel() {
        }

        @Override
        public <R> R match(BreakBehaviour.Cases<R> cases) {
            return cases.breakThisLevel();
        }

        @Override
        public String toString() {
            return "breakThisLevel()";
        }
    }

    private static final class PreferBreakingLastInnerLevel
    extends BreakBehaviour {
        private final boolean keepIndentWhenInlined;

        PreferBreakingLastInnerLevel(boolean keepIndentWhenInlined) {
            this.keepIndentWhenInlined = keepIndentWhenInlined;
        }

        @Override
        public <R> R match(BreakBehaviour.Cases<R> cases) {
            return cases.preferBreakingLastInnerLevel(this.keepIndentWhenInlined);
        }

        @Override
        public String toString() {
            return "preferBreakingLastInnerLevel(" + this.keepIndentWhenInlined + ")";
        }
    }

    private static final class InlineSuffix
    extends BreakBehaviour {
        InlineSuffix() {
        }

        @Override
        public <R> R match(BreakBehaviour.Cases<R> cases) {
            return cases.inlineSuffix();
        }

        @Override
        public String toString() {
            return "inlineSuffix()";
        }
    }

    private static final class BreakOnlyIfInnerLevelsThenFitOnOneLine
    extends BreakBehaviour {
        private final boolean keepIndentWhenInlined;

        BreakOnlyIfInnerLevelsThenFitOnOneLine(boolean keepIndentWhenInlined) {
            this.keepIndentWhenInlined = keepIndentWhenInlined;
        }

        @Override
        public <R> R match(BreakBehaviour.Cases<R> cases) {
            return cases.breakOnlyIfInnerLevelsThenFitOnOneLine(this.keepIndentWhenInlined);
        }

        @Override
        public String toString() {
            return "breakOnlyIfInnerLevelsThenFitOnOneLine(" + this.keepIndentWhenInlined + ")";
        }
    }

    private static final class Lazy
    extends BreakBehaviour {
        private volatile Supplier<BreakBehaviour> expression;
        private BreakBehaviour evaluation;

        Lazy(Supplier<BreakBehaviour> breakBehaviour) {
            this.expression = breakBehaviour;
        }

        private synchronized BreakBehaviour _evaluate() {
            block2: {
                BreakBehaviour eval;
                Lazy lazy = this;
                while (true) {
                    Supplier<BreakBehaviour> expr;
                    if ((expr = lazy.expression) == null) {
                        this.evaluation = lazy.evaluation;
                        break block2;
                    }
                    eval = expr.get();
                    if (!(eval instanceof Lazy)) break;
                    lazy = (Lazy)eval;
                }
                this.evaluation = eval;
            }
            this.expression = null;
            return this.evaluation;
        }

        @Override
        public <R> R match(BreakBehaviour.Cases<R> cases) {
            return (this.expression == null ? this.evaluation : this._evaluate()).match(cases);
        }

        @Override
        public String toString() {
            return (this.expression == null ? this.evaluation : this._evaluate()).toString();
        }
    }

    public static class CasesMatchers {
        private static final TotalMatcher_BreakThisLevel totalMatcher_BreakThisLevel = new TotalMatcher_BreakThisLevel();

        private CasesMatchers() {
        }

        public static final class TotalMatcher_BreakThisLevel {
            TotalMatcher_BreakThisLevel() {
            }

            public final <R> TotalMatcher_PreferBreakingLastInnerLevel<R> breakThisLevel(Supplier<R> breakThisLevel) {
                return new TotalMatcher_PreferBreakingLastInnerLevel<R>(breakThisLevel);
            }

            public final <R> TotalMatcher_PreferBreakingLastInnerLevel<R> breakThisLevel_(R r) {
                return this.breakThisLevel(() -> r);
            }

            public final <R> PartialMatcher_InlineSuffix<R> preferBreakingLastInnerLevel(Function<Boolean, R> preferBreakingLastInnerLevel) {
                return new PartialMatcher_InlineSuffix<R>(null, preferBreakingLastInnerLevel);
            }

            public final <R> PartialMatcher_InlineSuffix<R> preferBreakingLastInnerLevel_(R r) {
                return this.preferBreakingLastInnerLevel(keepIndentWhenInlined -> r);
            }

            public final <R> PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix(Supplier<R> inlineSuffix) {
                return new PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R>(null, null, inlineSuffix);
            }

            public final <R> PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix_(R r) {
                return this.inlineSuffix(() -> r);
            }

            public final <R> PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine(Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                return new PartialMatcher<R>(null, null, null, breakOnlyIfInnerLevelsThenFitOnOneLine);
            }

            public final <R> PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine_(R r) {
                return this.breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> r);
            }
        }

        public static class PartialMatcher<R> {
            private final Supplier<R> breakThisLevel;
            private final Function<Boolean, R> preferBreakingLastInnerLevel;
            private final Supplier<R> inlineSuffix;
            private final Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine;

            PartialMatcher(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix, Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                this.breakThisLevel = breakThisLevel;
                this.preferBreakingLastInnerLevel = preferBreakingLastInnerLevel;
                this.inlineSuffix = inlineSuffix;
                this.breakOnlyIfInnerLevelsThenFitOnOneLine = breakOnlyIfInnerLevelsThenFitOnOneLine;
            }

            public final Function<BreakBehaviour, R> otherwise(Supplier<R> otherwise) {
                BreakBehaviour.Cases cases = BreakBehaviours.cases(this.breakThisLevel != null ? this.breakThisLevel : () -> otherwise.get(), this.preferBreakingLastInnerLevel != null ? this.preferBreakingLastInnerLevel : keepIndentWhenInlined -> otherwise.get(), this.inlineSuffix != null ? this.inlineSuffix : () -> otherwise.get(), this.breakOnlyIfInnerLevelsThenFitOnOneLine != null ? this.breakOnlyIfInnerLevelsThenFitOnOneLine : keepIndentWhenInlined -> otherwise.get());
                return breakBehaviour -> breakBehaviour.match(cases);
            }

            public final Function<BreakBehaviour, R> otherwise_(R r) {
                return this.otherwise(() -> r);
            }

            public final Function<BreakBehaviour, Optional<R>> otherwiseEmpty() {
                BreakBehaviour.Cases<Optional> cases = BreakBehaviours.cases(this.breakThisLevel != null ? () -> Optional.of(this.breakThisLevel.get()) : () -> Optional.empty(), this.preferBreakingLastInnerLevel != null ? keepIndentWhenInlined -> Optional.of(this.preferBreakingLastInnerLevel.apply((Boolean)keepIndentWhenInlined)) : keepIndentWhenInlined -> Optional.empty(), this.inlineSuffix != null ? () -> Optional.of(this.inlineSuffix.get()) : () -> Optional.empty(), this.breakOnlyIfInnerLevelsThenFitOnOneLine != null ? keepIndentWhenInlined -> Optional.of(this.breakOnlyIfInnerLevelsThenFitOnOneLine.apply((Boolean)keepIndentWhenInlined)) : keepIndentWhenInlined -> Optional.empty());
                return breakBehaviour -> (Optional)breakBehaviour.match(cases);
            }
        }

        public static class PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R>
        extends PartialMatcher<R> {
            PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix) {
                super(breakThisLevel, preferBreakingLastInnerLevel, inlineSuffix, null);
            }

            public final PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine(Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                return new PartialMatcher(this.breakThisLevel, this.preferBreakingLastInnerLevel, this.inlineSuffix, breakOnlyIfInnerLevelsThenFitOnOneLine);
            }

            public final PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine_(R r) {
                return this.breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> r);
            }
        }

        public static class PartialMatcher_InlineSuffix<R>
        extends PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> {
            PartialMatcher_InlineSuffix(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel) {
                super(breakThisLevel, preferBreakingLastInnerLevel, null);
            }

            public final PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix(Supplier<R> inlineSuffix) {
                return new PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(this.breakThisLevel, this.preferBreakingLastInnerLevel, inlineSuffix);
            }

            public final PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix_(R r) {
                return this.inlineSuffix(() -> r);
            }
        }

        public static final class TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R>
        extends PartialMatcher<R> {
            TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix) {
                super(breakThisLevel, preferBreakingLastInnerLevel, inlineSuffix, null);
            }

            public final Function<BreakBehaviour, R> breakOnlyIfInnerLevelsThenFitOnOneLine(Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                BreakBehaviour.Cases cases = BreakBehaviours.cases(this.breakThisLevel, this.preferBreakingLastInnerLevel, this.inlineSuffix, breakOnlyIfInnerLevelsThenFitOnOneLine);
                return breakBehaviour -> breakBehaviour.match(cases);
            }

            public final Function<BreakBehaviour, R> breakOnlyIfInnerLevelsThenFitOnOneLine_(R r) {
                return this.breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> r);
            }
        }

        public static final class TotalMatcher_InlineSuffix<R>
        extends PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> {
            TotalMatcher_InlineSuffix(Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel) {
                super(breakThisLevel, preferBreakingLastInnerLevel, null);
            }

            public final TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix(Supplier<R> inlineSuffix) {
                return new TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(this.breakThisLevel, this.preferBreakingLastInnerLevel, inlineSuffix);
            }

            public final TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix_(R r) {
                return this.inlineSuffix(() -> r);
            }
        }

        public static final class TotalMatcher_PreferBreakingLastInnerLevel<R>
        extends PartialMatcher_InlineSuffix<R> {
            TotalMatcher_PreferBreakingLastInnerLevel(Supplier<R> breakThisLevel) {
                super(breakThisLevel, null);
            }

            public final TotalMatcher_InlineSuffix<R> preferBreakingLastInnerLevel(Function<Boolean, R> preferBreakingLastInnerLevel) {
                return new TotalMatcher_InlineSuffix(this.breakThisLevel, preferBreakingLastInnerLevel);
            }

            public final TotalMatcher_InlineSuffix<R> preferBreakingLastInnerLevel_(R r) {
                return this.preferBreakingLastInnerLevel(keepIndentWhenInlined -> r);
            }
        }
    }

    public static class CaseOfMatchers {
        private CaseOfMatchers() {
        }

        public static class PartialMatcher<R> {
            private final BreakBehaviour _breakBehaviour;
            private final Supplier<R> breakThisLevel;
            private final Function<Boolean, R> preferBreakingLastInnerLevel;
            private final Supplier<R> inlineSuffix;
            private final Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine;

            PartialMatcher(BreakBehaviour _breakBehaviour, Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix, Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                this._breakBehaviour = _breakBehaviour;
                this.breakThisLevel = breakThisLevel;
                this.preferBreakingLastInnerLevel = preferBreakingLastInnerLevel;
                this.inlineSuffix = inlineSuffix;
                this.breakOnlyIfInnerLevelsThenFitOnOneLine = breakOnlyIfInnerLevelsThenFitOnOneLine;
            }

            public final R otherwise(Supplier<R> otherwise) {
                BreakBehaviour.Cases<R> cases = BreakBehaviours.cases(this.breakThisLevel != null ? this.breakThisLevel : () -> otherwise.get(), this.preferBreakingLastInnerLevel != null ? this.preferBreakingLastInnerLevel : keepIndentWhenInlined -> otherwise.get(), this.inlineSuffix != null ? this.inlineSuffix : () -> otherwise.get(), this.breakOnlyIfInnerLevelsThenFitOnOneLine != null ? this.breakOnlyIfInnerLevelsThenFitOnOneLine : keepIndentWhenInlined -> otherwise.get());
                return this._breakBehaviour.match(cases);
            }

            public final R otherwise_(R r) {
                return (R)this.otherwise(() -> r);
            }

            public final Optional<R> otherwiseEmpty() {
                BreakBehaviour.Cases<Optional> cases = BreakBehaviours.cases(this.breakThisLevel != null ? () -> Optional.of(this.breakThisLevel.get()) : () -> Optional.empty(), this.preferBreakingLastInnerLevel != null ? keepIndentWhenInlined -> Optional.of(this.preferBreakingLastInnerLevel.apply((Boolean)keepIndentWhenInlined)) : keepIndentWhenInlined -> Optional.empty(), this.inlineSuffix != null ? () -> Optional.of(this.inlineSuffix.get()) : () -> Optional.empty(), this.breakOnlyIfInnerLevelsThenFitOnOneLine != null ? keepIndentWhenInlined -> Optional.of(this.breakOnlyIfInnerLevelsThenFitOnOneLine.apply((Boolean)keepIndentWhenInlined)) : keepIndentWhenInlined -> Optional.empty());
                return this._breakBehaviour.match(cases);
            }
        }

        public static class PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R>
        extends PartialMatcher<R> {
            PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(BreakBehaviour _breakBehaviour, Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix) {
                super(_breakBehaviour, breakThisLevel, preferBreakingLastInnerLevel, inlineSuffix, null);
            }

            public final PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine(Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                return new PartialMatcher(this._breakBehaviour, this.breakThisLevel, this.preferBreakingLastInnerLevel, this.inlineSuffix, breakOnlyIfInnerLevelsThenFitOnOneLine);
            }

            public final PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine_(R r) {
                return this.breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> r);
            }
        }

        public static class PartialMatcher_InlineSuffix<R>
        extends PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> {
            PartialMatcher_InlineSuffix(BreakBehaviour _breakBehaviour, Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel) {
                super(_breakBehaviour, breakThisLevel, preferBreakingLastInnerLevel, null);
            }

            public final PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix(Supplier<R> inlineSuffix) {
                return new PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(this._breakBehaviour, this.breakThisLevel, this.preferBreakingLastInnerLevel, inlineSuffix);
            }

            public final PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix_(R r) {
                return this.inlineSuffix(() -> r);
            }
        }

        public static final class TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R>
        extends PartialMatcher<R> {
            TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(BreakBehaviour _breakBehaviour, Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel, Supplier<R> inlineSuffix) {
                super(_breakBehaviour, breakThisLevel, preferBreakingLastInnerLevel, inlineSuffix, null);
            }

            public final R breakOnlyIfInnerLevelsThenFitOnOneLine(Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                BreakBehaviour.Cases cases = BreakBehaviours.cases(this.breakThisLevel, this.preferBreakingLastInnerLevel, this.inlineSuffix, breakOnlyIfInnerLevelsThenFitOnOneLine);
                return this._breakBehaviour.match(cases);
            }

            public final R breakOnlyIfInnerLevelsThenFitOnOneLine_(R r) {
                return (R)this.breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> r);
            }
        }

        public static final class TotalMatcher_InlineSuffix<R>
        extends PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> {
            TotalMatcher_InlineSuffix(BreakBehaviour _breakBehaviour, Supplier<R> breakThisLevel, Function<Boolean, R> preferBreakingLastInnerLevel) {
                super(_breakBehaviour, breakThisLevel, preferBreakingLastInnerLevel, null);
            }

            public final TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix(Supplier<R> inlineSuffix) {
                return new TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine(this._breakBehaviour, this.breakThisLevel, this.preferBreakingLastInnerLevel, inlineSuffix);
            }

            public final TotalMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix_(R r) {
                return this.inlineSuffix(() -> r);
            }
        }

        public static final class TotalMatcher_PreferBreakingLastInnerLevel<R>
        extends PartialMatcher_InlineSuffix<R> {
            TotalMatcher_PreferBreakingLastInnerLevel(BreakBehaviour _breakBehaviour, Supplier<R> breakThisLevel) {
                super(_breakBehaviour, breakThisLevel, null);
            }

            public final TotalMatcher_InlineSuffix<R> preferBreakingLastInnerLevel(Function<Boolean, R> preferBreakingLastInnerLevel) {
                return new TotalMatcher_InlineSuffix(this._breakBehaviour, this.breakThisLevel, preferBreakingLastInnerLevel);
            }

            public final TotalMatcher_InlineSuffix<R> preferBreakingLastInnerLevel_(R r) {
                return this.preferBreakingLastInnerLevel(keepIndentWhenInlined -> r);
            }
        }

        public static final class TotalMatcher_BreakThisLevel {
            private final BreakBehaviour _breakBehaviour;

            TotalMatcher_BreakThisLevel(BreakBehaviour _breakBehaviour) {
                this._breakBehaviour = _breakBehaviour;
            }

            public final <R> TotalMatcher_PreferBreakingLastInnerLevel<R> breakThisLevel(Supplier<R> breakThisLevel) {
                return new TotalMatcher_PreferBreakingLastInnerLevel<R>(this._breakBehaviour, breakThisLevel);
            }

            public final <R> TotalMatcher_PreferBreakingLastInnerLevel<R> breakThisLevel_(R r) {
                return this.breakThisLevel(() -> r);
            }

            public final <R> PartialMatcher_InlineSuffix<R> preferBreakingLastInnerLevel(Function<Boolean, R> preferBreakingLastInnerLevel) {
                return new PartialMatcher_InlineSuffix<R>(this._breakBehaviour, null, preferBreakingLastInnerLevel);
            }

            public final <R> PartialMatcher_InlineSuffix<R> preferBreakingLastInnerLevel_(R r) {
                return this.preferBreakingLastInnerLevel(keepIndentWhenInlined -> r);
            }

            public final <R> PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix(Supplier<R> inlineSuffix) {
                return new PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R>(this._breakBehaviour, null, null, inlineSuffix);
            }

            public final <R> PartialMatcher_BreakOnlyIfInnerLevelsThenFitOnOneLine<R> inlineSuffix_(R r) {
                return this.inlineSuffix(() -> r);
            }

            public final <R> PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine(Function<Boolean, R> breakOnlyIfInnerLevelsThenFitOnOneLine) {
                return new PartialMatcher<R>(this._breakBehaviour, null, null, null, breakOnlyIfInnerLevelsThenFitOnOneLine);
            }

            public final <R> PartialMatcher<R> breakOnlyIfInnerLevelsThenFitOnOneLine_(R r) {
                return this.breakOnlyIfInnerLevelsThenFitOnOneLine(keepIndentWhenInlined -> r);
            }
        }
    }
}

