/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import java.util.Optional;

final class CommandLineOptions {
    private final ImmutableList<String> files;
    private final boolean inPlace;
    private final ImmutableRangeSet<Integer> lines;
    private final ImmutableRangeSet<Integer> characterRanges;
    private final ImmutableList<Integer> offsets;
    private final ImmutableList<Integer> lengths;
    private final boolean aosp;
    private final boolean palantirStyle;
    private final boolean version;
    private final boolean help;
    private final boolean stdin;
    private final boolean fixImportsOnly;
    private final boolean sortImports;
    private final boolean removeUnusedImports;
    private final boolean dryRun;
    private final boolean setExitIfChanged;
    private final Optional<String> assumeFilename;
    private final boolean reflowLongStrings;
    private final boolean outputReplacements;

    CommandLineOptions(ImmutableList<String> files, boolean inPlace, ImmutableRangeSet<Integer> lines, ImmutableRangeSet<Integer> characterRanges, ImmutableList<Integer> offsets, ImmutableList<Integer> lengths, boolean aosp, boolean palantirStyle, boolean version, boolean help, boolean stdin, boolean fixImportsOnly, boolean sortImports, boolean removeUnusedImports, boolean dryRun, boolean setExitIfChanged, Optional<String> assumeFilename, boolean reflowLongStrings, boolean outputReplacements) {
        this.files = files;
        this.inPlace = inPlace;
        this.lines = lines;
        this.characterRanges = characterRanges;
        this.offsets = offsets;
        this.lengths = lengths;
        this.aosp = aosp;
        this.palantirStyle = palantirStyle;
        this.version = version;
        this.help = help;
        this.stdin = stdin;
        this.fixImportsOnly = fixImportsOnly;
        this.sortImports = sortImports;
        this.removeUnusedImports = removeUnusedImports;
        this.dryRun = dryRun;
        this.setExitIfChanged = setExitIfChanged;
        this.assumeFilename = assumeFilename;
        this.reflowLongStrings = reflowLongStrings;
        this.outputReplacements = outputReplacements;
    }

    ImmutableList<String> files() {
        return this.files;
    }

    boolean inPlace() {
        return this.inPlace;
    }

    ImmutableRangeSet<Integer> lines() {
        return this.lines;
    }

    ImmutableRangeSet<Integer> characterRanges() {
        return this.characterRanges;
    }

    ImmutableList<Integer> offsets() {
        return this.offsets;
    }

    ImmutableList<Integer> lengths() {
        return this.lengths;
    }

    boolean aosp() {
        return this.aosp;
    }

    boolean palantirStyle() {
        return this.palantirStyle;
    }

    boolean version() {
        return this.version;
    }

    boolean help() {
        return this.help;
    }

    boolean stdin() {
        return this.stdin;
    }

    boolean fixImportsOnly() {
        return this.fixImportsOnly;
    }

    boolean sortImports() {
        return this.sortImports;
    }

    boolean removeUnusedImports() {
        return this.removeUnusedImports;
    }

    boolean dryRun() {
        return this.dryRun;
    }

    boolean setExitIfChanged() {
        return this.setExitIfChanged;
    }

    Optional<String> assumeFilename() {
        return this.assumeFilename;
    }

    boolean reflowLongStrings() {
        return this.reflowLongStrings;
    }

    boolean isSelection() {
        return !this.lines().isEmpty() || !this.offsets().isEmpty() || !this.lengths().isEmpty();
    }

    boolean outputReplacements() {
        return this.outputReplacements;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private final ImmutableList.Builder<String> files = ImmutableList.builder();
        private final ImmutableRangeSet.Builder<Integer> lines = ImmutableRangeSet.builder();
        private final ImmutableRangeSet.Builder<Integer> characterRanges = ImmutableRangeSet.builder();
        private final ImmutableList.Builder<Integer> offsets = ImmutableList.builder();
        private final ImmutableList.Builder<Integer> lengths = ImmutableList.builder();
        private boolean inPlace = false;
        private boolean aosp = false;
        private boolean palantirStyle = false;
        private boolean version = false;
        private boolean help = false;
        private boolean stdin = false;
        private boolean fixImportsOnly = false;
        private boolean sortImports = true;
        private boolean removeUnusedImports = true;
        private boolean dryRun = false;
        private boolean setExitIfChanged = false;
        private Optional<String> assumeFilename = Optional.empty();
        private boolean reflowLongStrings = true;
        private boolean outputReplacements = false;

        private Builder() {
        }

        ImmutableList.Builder<String> filesBuilder() {
            return this.files;
        }

        Builder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        ImmutableRangeSet.Builder<Integer> linesBuilder() {
            return this.lines;
        }

        ImmutableRangeSet.Builder<Integer> characterRangesBuilder() {
            return this.characterRanges;
        }

        Builder addOffset(Integer offset) {
            this.offsets.add((Object)offset);
            return this;
        }

        Builder addLength(Integer length) {
            this.lengths.add((Object)length);
            return this;
        }

        Builder aosp(boolean aosp) {
            this.aosp = aosp;
            return this;
        }

        Builder palantirStyle(boolean palantirStyle) {
            this.palantirStyle = palantirStyle;
            return this;
        }

        Builder version(boolean version) {
            this.version = version;
            return this;
        }

        Builder help(boolean help) {
            this.help = help;
            return this;
        }

        Builder stdin(boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        Builder fixImportsOnly(boolean fixImportsOnly) {
            this.fixImportsOnly = fixImportsOnly;
            return this;
        }

        Builder sortImports(boolean sortImports) {
            this.sortImports = sortImports;
            return this;
        }

        Builder removeUnusedImports(boolean removeUnusedImports) {
            this.removeUnusedImports = removeUnusedImports;
            return this;
        }

        Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        Builder setExitIfChanged(boolean setExitIfChanged) {
            this.setExitIfChanged = setExitIfChanged;
            return this;
        }

        Builder assumeFilename(String assumeFilename) {
            this.assumeFilename = Optional.of(assumeFilename);
            return this;
        }

        Builder reflowLongStrings(boolean reflowLongStrings) {
            this.reflowLongStrings = reflowLongStrings;
            return this;
        }

        Builder outputReplacements(boolean outputReplacements) {
            this.outputReplacements = outputReplacements;
            return this;
        }

        CommandLineOptions build() {
            Preconditions.checkArgument((!this.aosp || !this.palantirStyle ? 1 : 0) != 0, (Object)"Cannot use both aosp and palantir style");
            return new CommandLineOptions((ImmutableList<String>)this.files.build(), this.inPlace, (ImmutableRangeSet<Integer>)this.lines.build(), (ImmutableRangeSet<Integer>)this.characterRanges.build(), (ImmutableList<Integer>)this.offsets.build(), (ImmutableList<Integer>)this.lengths.build(), this.aosp, this.palantirStyle, this.version, this.help, this.stdin, this.fixImportsOnly, this.sortImports, this.removeUnusedImports, this.dryRun, this.setExitIfChanged, this.assumeFilename, this.reflowLongStrings, this.outputReplacements);
        }
    }
}

