/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.palantir.javaformat.java.Formatter;
import com.palantir.javaformat.java.FormatterException;
import com.palantir.javaformat.java.FormatterService;
import com.palantir.javaformat.java.JavaFormatterOptions;
import com.palantir.javaformat.java.Replacement;
import java.util.Collection;

@AutoService(value={FormatterService.class})
public final class FormatterServiceImpl
implements FormatterService {
    private final Formatter formatter;

    public FormatterServiceImpl() {
        JavaFormatterOptions options = JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.PALANTIR).build();
        this.formatter = Formatter.createFormatter(options);
    }

    public ImmutableList<Replacement> getFormatReplacements(String text, Collection<Range<Integer>> toRanges) throws FormatterException {
        return this.formatter.getFormatReplacements(text, toRanges);
    }

    public String formatSourceReflowStringsAndFixImports(String input) throws FormatterException {
        return this.formatter.formatSourceAndFixImports(input);
    }
}

