/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.palantir.javaformat.Input;
import com.palantir.javaformat.Newlines;
import com.palantir.javaformat.OpsBuilder;
import com.palantir.javaformat.Output;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.java.Formatter;
import com.palantir.javaformat.java.InputMetadata;
import com.palantir.javaformat.java.JavaInput;
import com.palantir.javaformat.java.Replacement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class JavaOutput
extends Output {
    private final String lineSeparator;
    private final JavaInput javaInput;
    private final List<String> mutableLines = new ArrayList<String>();
    private final int kN;
    private final InputMetadata inputMetadata;
    private int iLine = 0;
    private int lastK = -1;
    private int spacesPending = 0;
    private int newlinesPending = 0;
    private StringBuilder lineBuilder = new StringBuilder();

    public JavaOutput(JavaInput javaInput, InputMetadata inputMetadata) {
        this.lineSeparator = javaInput.getLineSeparator();
        this.javaInput = javaInput;
        this.kN = javaInput.getkN();
        this.inputMetadata = inputMetadata;
    }

    @Override
    public void append(State state, String text, Range<Integer> range) {
        if (!range.isEmpty()) {
            boolean sawNewlines = false;
            int iN = this.javaInput.getLineCount();
            while (this.iLine < iN && (this.javaInput.getRanges(this.iLine).isEmpty() || (Integer)this.javaInput.getRanges(this.iLine).upperEndpoint() <= (Integer)range.lowerEndpoint())) {
                if (this.javaInput.getRanges(this.iLine).isEmpty()) {
                    sawNewlines = true;
                }
                ++this.iLine;
            }
            OpsBuilder.BlankLineWanted wanted = (OpsBuilder.BlankLineWanted)this.inputMetadata.blankLines().getOrDefault((Object)this.lastK, (Object)OpsBuilder.BlankLineWanted.NO);
            if (this.isComment(text) ? sawNewlines : wanted.wanted(state).orElse(sawNewlines) != false) {
                ++this.newlinesPending;
            }
        }
        if (Newlines.isNewline(text)) {
            if (this.newlinesPending == 0) {
                ++this.newlinesPending;
            }
            this.spacesPending = 0;
        } else {
            boolean rangesSet = false;
            int textN = text.length();
            block6: for (int i = 0; i < textN; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        ++this.spacesPending;
                        continue block6;
                    }
                    case '\r': {
                        if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        this.spacesPending = 0;
                        ++this.newlinesPending;
                        continue block6;
                    }
                    default: {
                        while (this.newlinesPending > 0) {
                            if (!this.mutableLines.isEmpty() || this.lineBuilder.length() > 0) {
                                this.mutableLines.add(this.lineBuilder.toString());
                            }
                            this.lineBuilder = new StringBuilder();
                            rangesSet = false;
                            --this.newlinesPending;
                        }
                        while (this.spacesPending > 0) {
                            this.lineBuilder.append(' ');
                            --this.spacesPending;
                        }
                        this.lineBuilder.append(c);
                        if (range.isEmpty() || rangesSet) continue block6;
                        while (this.ranges.size() <= this.mutableLines.size()) {
                            this.ranges.add(Formatter.EMPTY_RANGE);
                        }
                        this.ranges.set(this.mutableLines.size(), JavaOutput.union((Range<Integer>)((Range)this.ranges.get(this.mutableLines.size())), range));
                        rangesSet = true;
                    }
                }
            }
        }
        if (!range.isEmpty()) {
            this.lastK = (Integer)range.upperEndpoint();
        }
    }

    @Override
    public void indent(int indent) {
        this.spacesPending = indent;
    }

    void flush() {
        String lastLine = this.lineBuilder.toString();
        if (!CharMatcher.whitespace().matchesAllOf((CharSequence)lastLine)) {
            this.mutableLines.add(lastLine);
        }
        int jN = this.mutableLines.size();
        Range eofRange = Range.closedOpen((Comparable)Integer.valueOf(this.kN), (Comparable)Integer.valueOf(this.kN + 1));
        while (this.ranges.size() < jN) {
            this.ranges.add(Formatter.EMPTY_RANGE);
        }
        this.ranges.add(eofRange);
        this.setLines((ImmutableList<String>)ImmutableList.copyOf(this.mutableLines));
    }

    public ImmutableList<Replacement> getFormatReplacements(RangeSet<Integer> iRangeSet0) {
        ImmutableList.Builder result = ImmutableList.builder();
        Map<Integer, Range<Integer>> kToJ = JavaOutput.makeKToIJ(this);
        TreeRangeSet breakableRanges = TreeRangeSet.create();
        RangeSet iRangeSet = iRangeSet0.subRangeSet(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.javaInput.getkN())));
        for (Range iRange : iRangeSet.asRanges()) {
            Range<Integer> range = this.expandToBreakableRegions((Range<Integer>)iRange.canonical(DiscreteDomain.integers()));
            if (range.equals((Object)EMPTY_RANGE)) continue;
            breakableRanges.add(range);
        }
        for (Range range : breakableRanges.asRanges()) {
            int i;
            int replaceFrom;
            Input.Tok startTok = JavaOutput.startTok(this.javaInput.getToken((Integer)range.lowerEndpoint()));
            Input.Tok endTok = JavaOutput.endTok(this.javaInput.getToken((Integer)range.upperEndpoint() - 1));
            StringBuilder replacement = new StringBuilder();
            for (replaceFrom = startTok.getPosition(); replaceFrom > 0; --replaceFrom) {
                char previous = this.javaInput.getText().charAt(replaceFrom - 1);
                if (!CharMatcher.whitespace().matches(previous)) break;
            }
            for (i = ((Integer)kToJ.get(startTok.getIndex()).lowerEndpoint()).intValue(); i > 0 && this.getLine(i - 1).isEmpty(); --i) {
            }
            while (i < (Integer)kToJ.get(endTok.getIndex()).upperEndpoint()) {
                if (i < this.getLineCount()) {
                    if (i > 0) {
                        replacement.append(this.lineSeparator);
                    }
                    replacement.append(this.getLine(i));
                }
                ++i;
            }
            int replaceTo = Math.min(endTok.getPosition() + endTok.length(), this.javaInput.getText().length());
            if (endTok.getIndex() == this.javaInput.getkN() - 1) {
                replaceTo = this.javaInput.getText().length();
            }
            int newline = -1;
            while (replaceTo < this.javaInput.getText().length()) {
                char next = this.javaInput.getText().charAt(replaceTo);
                if (!CharMatcher.whitespace().matches(next)) break;
                int newlineLength = Newlines.hasNewlineAt(this.javaInput.getText(), replaceTo);
                if (newlineLength != -1) {
                    newline = replaceTo;
                    replaceTo += newlineLength;
                    continue;
                }
                ++replaceTo;
            }
            if (newline != -1) {
                replaceTo = newline;
            }
            if (newline == -1) {
                replacement.append(this.lineSeparator);
            }
            while (i < this.getLineCount()) {
                String after = this.getLine(i);
                int idx = CharMatcher.whitespace().negate().indexIn((CharSequence)after);
                if (idx != -1) {
                    if (newline != -1) break;
                    replacement.append(after, 0, idx);
                    break;
                }
                replacement.append(this.lineSeparator);
                ++i;
            }
            result.add((Object)Replacement.create((int)replaceFrom, (int)replaceTo, (String)replacement.toString()));
        }
        return result.build();
    }

    private Range<Integer> expandToBreakableRegions(Range<Integer> iRange) {
        int loTok = (Integer)iRange.lowerEndpoint();
        int hiTok = (Integer)iRange.upperEndpoint() - 1;
        if (!this.partialFormatRanges().contains((Comparable)Integer.valueOf(loTok)) || !this.partialFormatRanges().contains((Comparable)Integer.valueOf(hiTok))) {
            return EMPTY_RANGE;
        }
        loTok = (Integer)this.partialFormatRanges().rangeContaining((Comparable)Integer.valueOf(loTok)).lowerEndpoint();
        hiTok = (Integer)this.partialFormatRanges().rangeContaining((Comparable)Integer.valueOf(hiTok)).upperEndpoint();
        return Range.closedOpen((Comparable)Integer.valueOf(loTok), (Comparable)Integer.valueOf(hiTok + 1));
    }

    private RangeSet<Integer> partialFormatRanges() {
        return this.inputMetadata.partialFormatRanges();
    }

    public static int startPosition(Input.Token token) {
        int min = token.getTok().getPosition();
        for (Input.Tok tok : token.getToksBefore()) {
            min = Math.min(min, tok.getPosition());
        }
        return min;
    }

    public static Input.Tok startTok(Input.Token token) {
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token.getTok();
    }

    public static Input.Tok endTok(Input.Token token) {
        for (int i = token.getToksAfter().size() - 1; i >= 0; --i) {
            Input.Tok tok = (Input.Tok)token.getToksAfter().get(i);
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token.getTok();
    }

    private boolean isComment(String text) {
        return text.startsWith("//") || text.startsWith("/*");
    }

    private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
        return x.isEmpty() ? y : (y.isEmpty() ? x : x.span(y).canonical(DiscreteDomain.integers()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("iLine", this.iLine).add("lastK", this.lastK).add("spacesPending", this.spacesPending).add("newlinesPending", this.newlinesPending).add("inputMetadata", (Object)this.inputMetadata).add("super", (Object)super.toString()).toString();
    }
}

