/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.palantir.javaformat.doc.HasUniqueId;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.State;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;

public final class Obs {
    private Obs() {
    }

    public static ExplorationNode createRoot(Sink sink) {
        return new ExplorationNodeImpl(null, "(initial node)", sink, 0, Optional.empty());
    }

    private static class ExplorationNodeImpl
    extends HasUniqueId
    implements ExplorationNode {
        private final Sink sink;
        private final FinishExplorationNode finishExplorationNode;
        private final Optional<Level> parentLevel;

        public ExplorationNodeImpl(LevelNodeImpl parent, String humanDescription, Sink sink, int startColumn, Optional<State> incomingState) {
            this.parentLevel = Optional.ofNullable(parent).map(p -> p.level);
            this.sink = sink;
            this.finishExplorationNode = sink.startExplorationNode(this.id(), parent != null ? OptionalInt.of(parent.id()) : OptionalInt.empty(), humanDescription, startColumn, incomingState);
        }

        @Override
        public LevelNode newChildNode(Level level, State state) {
            return new LevelNodeImpl(level, state, this.id(), this.sink);
        }

        void recordNewState(Optional<State> maybeNewState) {
            maybeNewState.ifPresent(newState -> this.parentLevel.ifPresent(parent -> this.finishExplorationNode.finishNode((Level)parent, (State)newState)));
        }
    }

    private static class LevelNodeImpl
    extends HasUniqueId
    implements LevelNode {
        private final Level level;
        private final Sink sink;
        private final FinishLevelNode finisher;
        private final int startColumn;

        public LevelNodeImpl(Level level, State incomingState, int parentExplorationId, Sink sink) {
            this.level = level;
            this.sink = sink;
            this.finisher = sink.writeLevelNode(this.id(), parentExplorationId, incomingState, level);
            this.startColumn = incomingState.column();
        }

        @Override
        public Exploration explore(String humanDescription, State incomingState, Function<ExplorationNode, State> explorationFunc) {
            final ExplorationNodeImpl explorationNode = new ExplorationNodeImpl(this, humanDescription, this.sink, this.startColumn, Optional.of(incomingState));
            final State newState = explorationFunc.apply(explorationNode);
            explorationNode.recordNewState(Optional.of(newState));
            return new Exploration(){

                @Override
                public State markAccepted() {
                    finisher.finishNode(explorationNode.id());
                    return newState;
                }

                @Override
                public State state() {
                    return newState;
                }
            };
        }

        @Override
        public Optional<Exploration> maybeExplore(String humanDescription, State incomingState, Function<ExplorationNode, Optional<State>> explorationFunc) {
            final ExplorationNodeImpl explorationNode = new ExplorationNodeImpl(this, humanDescription, this.sink, this.startColumn, Optional.of(incomingState));
            Optional<State> maybeNewState = explorationFunc.apply(explorationNode);
            explorationNode.recordNewState(maybeNewState);
            if (!maybeNewState.isPresent()) {
                return Optional.empty();
            }
            final State newState = maybeNewState.get();
            return Optional.of(new Exploration(){

                @Override
                public State markAccepted() {
                    finisher.finishNode(explorationNode.id());
                    return newState;
                }

                @Override
                public State state() {
                    return newState;
                }
            });
        }

        @Override
        public State finishLevel(State state) {
            return state;
        }
    }

    public static interface Sink {
        public FinishExplorationNode startExplorationNode(int var1, OptionalInt var2, String var3, int var4, Optional<State> var5);

        @CheckReturnValue
        public FinishLevelNode writeLevelNode(int var1, int var2, State var3, Level var4);

        public String getOutput();
    }

    static interface Exploration {
        public State markAccepted();

        public State state();
    }

    static interface LevelNode {
        public Exploration explore(String var1, State var2, Function<ExplorationNode, State> var3);

        public int id();

        public Optional<Exploration> maybeExplore(String var1, State var2, Function<ExplorationNode, Optional<State>> var3);

        public State finishLevel(State var1);
    }

    public static interface ExplorationNode {
        public LevelNode newChildNode(Level var1, State var2);

        public int id();
    }

    public static interface FinishExplorationNode {
        public void finishNode(Level var1, State var2);
    }

    public static interface FinishLevelNode {
        public void finishNode(int var1);
    }
}

