/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tokens.auth;

import com.palantir.tokens.auth.BearerToken;
import com.palantir.tokens.auth.ImmutableAuthHeader;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AuthHeader {
    @Value.Parameter
    public abstract BearerToken getBearerToken();

    public static AuthHeader valueOf(String authHeader) {
        BearerToken bearerToken = BearerToken.valueOf(authHeader.startsWith("Bearer ") ? authHeader.substring(7) : authHeader);
        return ImmutableAuthHeader.of(bearerToken);
    }

    public static AuthHeader of(BearerToken bearerToken) {
        return ImmutableAuthHeader.of(bearerToken);
    }

    public final String toString() {
        return "Bearer " + this.getBearerToken().getToken();
    }
}

