/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import com.pivovarit.collectors.AsyncParallelCollector;
import com.pivovarit.collectors.FutureCollectors;
import com.pivovarit.collectors.ParallelStreamCollector;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class ParallelCollectors {
    private ParallelCollectors() {
    }

    public static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> parallel(Function<T, R> mapper, Collector<R, ?, RR> collector) {
        return AsyncParallelCollector.collectingWithCollector(collector, mapper);
    }

    public static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> parallel(Function<T, R> mapper, Collector<R, ?, RR> collector, Executor executor, int parallelism) {
        return AsyncParallelCollector.collectingWithCollector(collector, mapper, executor, parallelism);
    }

    public static <T, R> Collector<T, ?, CompletableFuture<Stream<R>>> parallel(Function<T, R> mapper) {
        return AsyncParallelCollector.collectingToStream(mapper);
    }

    public static <T, R> Collector<T, ?, CompletableFuture<Stream<R>>> parallel(Function<T, R> mapper, Executor executor, int parallelism) {
        return AsyncParallelCollector.collectingToStream(mapper, executor, parallelism);
    }

    public static <T, R> Collector<T, ?, Stream<R>> parallelToStream(Function<T, R> mapper) {
        return ParallelStreamCollector.streaming(mapper);
    }

    public static <T, R> Collector<T, ?, Stream<R>> parallelToStream(Function<T, R> mapper, Executor executor, int parallelism) {
        return ParallelStreamCollector.streaming(mapper, executor, parallelism);
    }

    public static <T, R> Collector<T, ?, Stream<R>> parallelToOrderedStream(Function<T, R> mapper) {
        return ParallelStreamCollector.streamingOrdered(mapper);
    }

    public static <T, R> Collector<T, ?, Stream<R>> parallelToOrderedStream(Function<T, R> mapper, Executor executor, int parallelism) {
        return ParallelStreamCollector.streamingOrdered(mapper, executor, parallelism);
    }

    public static <T, R> Collector<CompletableFuture<T>, ?, CompletableFuture<R>> toFuture(Collector<T, ?, R> collector) {
        return FutureCollectors.toFuture(collector);
    }

    public static <T> Collector<CompletableFuture<T>, ?, CompletableFuture<List<T>>> toFuture() {
        return FutureCollectors.toFuture();
    }

    public static final class Batching {
        private Batching() {
        }

        public static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> parallel(Function<T, R> mapper, Collector<R, ?, RR> collector, Executor executor, int parallelism) {
            return AsyncParallelCollector.BatchingCollectors.collectingWithCollector(collector, mapper, executor, parallelism);
        }

        public static <T, R> Collector<T, ?, CompletableFuture<Stream<R>>> parallel(Function<T, R> mapper, Executor executor, int parallelism) {
            return AsyncParallelCollector.BatchingCollectors.collectingToStream(mapper, executor, parallelism);
        }

        public static <T, R> Collector<T, ?, Stream<R>> parallelToStream(Function<T, R> mapper, Executor executor, int parallelism) {
            return ParallelStreamCollector.BatchingCollectors.streaming(mapper, executor, parallelism);
        }

        public static <T, R> Collector<T, ?, Stream<R>> parallelToOrderedStream(Function<T, R> mapper, Executor executor, int parallelism) {
            return ParallelStreamCollector.BatchingCollectors.streamingOrdered(mapper, executor, parallelism);
        }
    }
}

