/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.spring.config;

import feign.Contract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactivefeign.FallbackFactory;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.spring.config.ReactiveFeignConfigurator;
import reactivefeign.spring.config.ReactiveFeignNamedContext;

class ReactiveFeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware {
    private Class<?> type;
    private String name;
    private String url;
    private String path;
    private boolean decode404;
    private ApplicationContext applicationContext;
    private Class<?> fallback = Void.TYPE;
    private Class<?> fallbackFactory = Void.TYPE;

    ReactiveFeignClientFactoryBean() {
    }

    public void afterPropertiesSet() {
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public Object getObject() {
        return this.getTarget();
    }

    private <T> T getTarget() {
        ReactiveFeignNamedContext namedContext = new ReactiveFeignNamedContext(this.applicationContext, this.name);
        ReactiveFeignBuilder builder = namedContext.get(ReactiveFeignBuilder.class).contract(namedContext.get(Contract.class));
        builder = this.applyConfigurators(builder, namedContext);
        if (this.decode404) {
            builder = builder.decode404();
        }
        builder = this.fallback(builder, namedContext);
        return (T)(StringUtils.hasText((String)this.url) ? builder.target(this.type, this.buildUrl()) : builder.target(this.type, this.name, this.buildUrl()));
    }

    protected ReactiveFeignBuilder applyConfigurators(ReactiveFeignBuilder builder, ReactiveFeignNamedContext namedContext) {
        ArrayList<ReactiveFeignConfigurator> configurators = new ArrayList<ReactiveFeignConfigurator>(namedContext.getAll(ReactiveFeignConfigurator.class).values());
        Collections.sort(configurators);
        for (ReactiveFeignConfigurator configurator : configurators) {
            builder = configurator.configure(builder, namedContext);
        }
        return builder;
    }

    private String buildUrl() {
        Object url = !StringUtils.hasText((String)this.url) ? (!this.name.startsWith("http") ? "http://" + this.name : this.name) : (!this.url.startsWith("http") ? "http://" + this.url : this.url);
        url = (String)url + this.cleanPath();
        return url;
    }

    private <T> ReactiveFeignBuilder fallback(ReactiveFeignBuilder builder, ReactiveFeignNamedContext context) {
        if (this.fallback != Void.TYPE) {
            Object fallbackInstance = this.getFallbackFromContext("fallback", context, this.fallback, this.type);
            builder = builder.fallback(fallbackInstance);
            return builder;
        }
        if (this.fallbackFactory != Void.TYPE) {
            FallbackFactory fallbackFactoryInstance = this.getFallbackFromContext("fallbackFactory", context, this.fallbackFactory, FallbackFactory.class);
            builder = builder.fallbackFactory(fallbackFactoryInstance);
            return builder;
        }
        FallbackFactory fallbackFactoryInstance = context.getOptional(FallbackFactory.class);
        if (fallbackFactoryInstance != null) {
            builder = builder.fallbackFactory(fallbackFactoryInstance);
        }
        return builder;
    }

    private <T> T getFallbackFromContext(String fallbackMechanism, ReactiveFeignNamedContext context, Class<?> beanType, Class<T> targetType) {
        Object fallbackInstance = context.getOptional(beanType);
        if (!targetType.isAssignableFrom(beanType)) {
            throw new IllegalStateException(String.format("Incompatible " + fallbackMechanism + " instance. Fallback/fallbackFactory of type %s is not assignable to %s for feign client %s", beanType, targetType, context.getClientName()));
        }
        if (fallbackInstance == null) {
            fallbackInstance = context.getOrInstantiate(beanType);
        }
        return (T)fallbackInstance;
    }

    private String cleanPath() {
        Object path = this.path.trim();
        if (StringUtils.hasLength((String)path)) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
        }
        return path;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDecode404() {
        return this.decode404;
    }

    public void setDecode404(boolean decode404) {
        this.decode404 = decode404;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Class<?> getFallback() {
        return this.fallback;
    }

    public void setFallback(Class<?> fallback) {
        this.fallback = fallback;
    }

    public Class<?> getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setFallbackFactory(Class<?> fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactiveFeignClientFactoryBean that = (ReactiveFeignClientFactoryBean)o;
        return Objects.equals(this.applicationContext, that.applicationContext) && this.decode404 == that.decode404 && Objects.equals(this.fallback, that.fallback) && Objects.equals(this.fallbackFactory, that.fallbackFactory) && Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.applicationContext, this.decode404, this.fallback, this.fallbackFactory, this.name, this.path, this.type, this.url);
    }

    public String toString() {
        return "ReactiveFeignClientFactoryBean{" + "type=" + this.type + ", " + "name='" + this.name + "', " + "url='" + this.url + "', " + "path='" + this.path + "', " + "decode404=" + this.decode404 + ", " + "applicationContext=" + this.applicationContext + ", " + "fallback=" + this.fallback + ", " + "fallbackFactory=" + this.fallbackFactory + "}";
    }
}

