/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OffsetTimeAdapter
extends XmlAdapter<String, OffsetTime> {
    private static final Logger log = Logger.getLogger(OffsetTime.class.getName());
    private final DateTimeFormatter marshalFormat;
    private final DateTimeFormatter unmarshalFormat;
    private final XmlAdapter<String, OffsetTime> customAdapterImpl;
    int minPrecision = 0;
    int maxPrecision = 9;

    public OffsetTimeAdapter() {
        this.unmarshalFormat = this.marshalFormat = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, this.minPrecision, this.maxPrecision, true).optionalEnd().optionalStart().appendPattern("XXX").optionalEnd().toFormatter();
        this.customAdapterImpl = null;
    }

    public OffsetTimeAdapter(DateTimeFormatter dateFormat) {
        this.marshalFormat = dateFormat;
        this.unmarshalFormat = dateFormat;
        this.customAdapterImpl = null;
    }

    public OffsetTimeAdapter(XmlAdapter<String, OffsetTime> customAdapterImpl) {
        this.marshalFormat = null;
        this.unmarshalFormat = null;
        this.customAdapterImpl = customAdapterImpl;
    }

    public OffsetTime unmarshal(String value) throws Exception {
        if (this.customAdapterImpl != null) {
            return (OffsetTime)this.customAdapterImpl.unmarshal((Object)value);
        }
        return OffsetTimeAdapter.parseOffsetTime(this.unmarshalFormat, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal(OffsetTime offsetTime) throws Exception {
        String formatted;
        if (this.customAdapterImpl != null) {
            return (String)this.customAdapterImpl.marshal((Object)offsetTime);
        }
        DateTimeFormatter dateTimeFormatter = this.marshalFormat;
        synchronized (dateTimeFormatter) {
            formatted = OffsetTimeAdapter.formatOffsetTime(this.marshalFormat, offsetTime);
        }
        return formatted.replace(".000", "").replace("Z", "+00:00");
    }

    static String formatOffsetTime(DateTimeFormatter dateTimeFormatter, OffsetTime offsetTime) {
        return dateTimeFormatter.format(offsetTime);
    }

    static OffsetTime parseOffsetTime(DateTimeFormatter dateTimeFormatter, String value) {
        OffsetTime offsetTime;
        if (value == null) {
            return null;
        }
        try {
            offsetTime = OffsetTime.parse(value, dateTimeFormatter);
        }
        catch (DateTimeParseException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Error parsing to OffsetTime: " + e.getMessage());
            }
            ZoneOffset offset = ZoneOffset.systemDefault().getRules().getStandardOffset(Instant.now());
            offsetTime = LocalTime.parse(value, dateTimeFormatter).atOffset(offset);
        }
        return offsetTime;
    }

    public String toString() {
        return "OffsetTimeAdapter{ HH:mm:ss[.SSS][XXX] }";
    }
}

