/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OffsetTimeJsonAdapter
implements JsonSerializer<OffsetTime>,
JsonDeserializer<OffsetTime> {
    private static final Logger log = Logger.getLogger(OffsetTimeJsonAdapter.class.getName());
    private final Gson gson = new Gson();

    public JsonElement serialize(OffsetTime offsetTime, Type type, JsonSerializationContext jsonSerializationContext) {
        TimeOffsetDTO timeOffsetDTO = new TimeOffsetDTO();
        timeOffsetDTO.time.hour = offsetTime.getHour();
        timeOffsetDTO.time.minute = offsetTime.getMinute();
        timeOffsetDTO.time.second = offsetTime.getSecond();
        timeOffsetDTO.time.nano = offsetTime.getNano();
        if (offsetTime.getOffset() != null) {
            timeOffsetDTO.offset = new OffsetDTO();
            timeOffsetDTO.offset.totalSeconds = offsetTime.getOffset().getTotalSeconds();
        }
        return this.gson.toJsonTree((Object)timeOffsetDTO, TimeOffsetDTO.class);
    }

    public OffsetTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            OffsetTime offsetTime;
            TimeOffsetDTO timeDTO = (TimeOffsetDTO)this.gson.fromJson(jsonElement, TimeOffsetDTO.class);
            int nano = 0;
            if (timeDTO.time.nano != null) {
                nano = timeDTO.time.nano;
            }
            if (timeDTO.offset != null) {
                ZoneOffset zoneoffset = ZoneOffset.ofTotalSeconds(timeDTO.offset.totalSeconds);
                offsetTime = OffsetTime.of(timeDTO.time.hour, timeDTO.time.minute, timeDTO.time.second, nano, zoneoffset);
            } else {
                LocalTime localTime = LocalTime.of(timeDTO.time.hour, timeDTO.time.minute, timeDTO.time.second, nano);
                offsetTime = localTime.atOffset(OffsetTime.now().getOffset());
            }
            return offsetTime;
        }
        catch (Exception e) {
            log.log(Level.FINEST, "Cannot parse JSON into OffsetTime: " + e.getMessage(), e);
            return null;
        }
    }

    static class OffsetDTO {
        Integer totalSeconds = 0;

        OffsetDTO() {
        }
    }

    static class TimeDTO {
        Integer hour = 0;
        Integer minute = 0;
        Integer second = 0;
        Integer nano = 0;

        TimeDTO() {
        }
    }

    static class TimeOffsetDTO {
        private TimeDTO time = new TimeDTO();
        private OffsetDTO offset;

        TimeOffsetDTO() {
        }
    }
}

