/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.YearMonth;

public class YearMonthJsonAdapter
implements JsonSerializer<YearMonth>,
JsonDeserializer<YearMonth> {
    private final Gson gson = new Gson();

    public JsonElement serialize(YearMonth yearMonth, Type type, JsonSerializationContext jsonSerializationContext) {
        YearMonthJsonDTO yearJsonDTO = new YearMonthJsonDTO();
        yearJsonDTO.year = yearMonth.getYear();
        yearJsonDTO.month = yearMonth.getMonth().getValue();
        return this.gson.toJsonTree((Object)yearJsonDTO, YearMonthJsonDTO.class);
    }

    public YearMonth deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        YearMonthJsonDTO yearMonthJsonDTO = (YearMonthJsonDTO)this.gson.fromJson(jsonElement, YearMonthJsonDTO.class);
        return YearMonth.of(yearMonthJsonDTO.year, yearMonthJsonDTO.month);
    }

    static class YearMonthJsonDTO {
        int year;
        int month;

        YearMonthJsonDTO() {
        }
    }
}

