/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.EscapeHandler;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.MxWrite;
import com.prowidesoftware.swift.model.mx.MxWriteParams;
import com.prowidesoftware.swift.model.mx.MxWriteUtils;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.XsysNamespaces;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;

public class MxWriteImpl
implements MxWrite {
    private static final transient Logger log = Logger.getLogger(MxWriteImpl.class.getName());

    @Deprecated
    public static String write(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration) {
        DeprecationUtils.phase2(MxWriteImpl.class, (String)"write(String, AbstractMX, Class[], String, boolean)", (String)"Use write(String, AbstractMX, Class[], MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        return MxWriteImpl.write(namespace, obj, classes, params);
    }

    @Deprecated
    public static String write(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        DeprecationUtils.phase2(MxWriteImpl.class, (String)"write(String, AbstractMX, Class[], String, boolean, EscapeHandler)", (String)"Use write(String, AbstractMX, Class[], MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        params.escapeHandler = escapeHandler;
        return MxWriteImpl.write(namespace, obj, classes, params);
    }

    public static String write(String namespace, AbstractMX obj, Class[] classes, MxWriteParams params) {
        Objects.requireNonNull(namespace, "namespace can not be null");
        Objects.requireNonNull(obj, "MxSwiftMessage can not be null");
        Objects.requireNonNull(classes, "Class[] can not be null");
        Objects.requireNonNull(params, "marshalling params cannot be null");
        try {
            JAXBContext context = JaxbContextLoader.INSTANCE.get(obj);
            JAXBElement element = new JAXBElement(new QName("Document"), ((Object)((Object)obj)).getClass(), null, (Object)obj);
            Marshaller marshaller = MxWriteUtils.createMarshaller(context, params);
            StringWriter sw = new StringWriter();
            XmlEventWriter writer = new XmlEventWriter(sw, params.prefix, params.includeXMLDeclaration, "Document", params.escapeHandler);
            HashMap<String, String> preferredPrefixes = new HashMap<String, String>();
            for (XsysNamespaces xsys : XsysNamespaces.values()) {
                preferredPrefixes.put(xsys.namespaceURI(), xsys.prefix());
            }
            writer.setPreferredPrefixes(preferredPrefixes);
            marshaller.marshal((Object)element, (XMLEventWriter)writer);
            if (log.isLoggable(Level.FINER)) {
                log.finer("XML: \n" + sw.getBuffer().toString());
            }
            return sw.getBuffer().toString();
        }
        catch (ExecutionException | JAXBException e) {
            log.log(Level.SEVERE, "Error writing XML:" + e + "\n for message: " + (Object)((Object)obj));
            return null;
        }
    }

    @Override
    @Deprecated
    public String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration) {
        DeprecationUtils.phase2(MxWriteImpl.class, (String)"message(String, AbstractMX, Class[], String, boolean)", (String)"Use write(String, AbstractMX, Class[], MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        return MxWriteImpl.write(namespace, obj, classes, params);
    }

    @Override
    @Deprecated
    public String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        params.escapeHandler = escapeHandler;
        return MxWriteImpl.write(namespace, obj, classes, params);
    }
}

