/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

class AdapterUtils {
    private static final transient Logger log = Logger.getLogger(AdapterUtils.class.getName());

    AdapterUtils() {
    }

    static String format(SimpleDateFormat dateFormat, XMLGregorianCalendar calendar) {
        GregorianCalendar gregorianCalendar = calendar.toGregorianCalendar();
        Date date = gregorianCalendar.getTime();
        dateFormat.setCalendar(gregorianCalendar);
        return dateFormat.format(date);
    }

    static XMLGregorianCalendar parse(SimpleDateFormat dateFormat, String value) {
        if (value == null) {
            return null;
        }
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(value);
        }
        catch (IllegalArgumentException | DatatypeConfigurationException e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Error parsing to XMLGregorianCalendar: " + e.getMessage());
            }
            try {
                Date date = dateFormat.parse(value);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
            }
            catch (ParseException | DatatypeConfigurationException e2) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Error parsing XMLGregorianCalendar with " + dateFormat.toPattern() + ": " + e2.getMessage());
                }
                return null;
            }
        }
    }
}

