
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * This message is a query message with specification of requested accounts, and requested characteristics.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AccountQueryListV01", propOrder = {
    "refs",
    "acctSvcrId",
    "org",
    "acctSchCrit",
    "acctRtrCrit",
    "dgtlSgntr"
})
public class AccountQueryListV01 {

    @XmlElement(name = "Refs", required = true)
    protected References4 refs;
    @XmlElement(name = "AcctSvcrId", required = true)
    protected BranchAndFinancialInstitutionIdentification4 acctSvcrId;
    @XmlElement(name = "Org", required = true)
    protected List<Organisation7> org;
    @XmlElement(name = "AcctSchCrit", required = true)
    protected CustomerAccount2 acctSchCrit;
    @XmlElement(name = "AcctRtrCrit")
    protected CustomerAccountReturnCriteria1 acctRtrCrit;
    @XmlElement(name = "DgtlSgntr")
    protected List<PartyAndSignature1> dgtlSgntr;

    /**
     * Gets the value of the refs property.
     * 
     * @return
     *     possible object is
     *     {@link References4 }
     *     
     */
    public References4 getRefs() {
        return refs;
    }

    /**
     * Sets the value of the refs property.
     * 
     * @param value
     *     allowed object is
     *     {@link References4 }
     *     
     */
    public AccountQueryListV01 setRefs(References4 value) {
        this.refs = value;
        return this;
    }

    /**
     * Gets the value of the acctSvcrId property.
     * 
     * @return
     *     possible object is
     *     {@link BranchAndFinancialInstitutionIdentification4 }
     *     
     */
    public BranchAndFinancialInstitutionIdentification4 getAcctSvcrId() {
        return acctSvcrId;
    }

    /**
     * Sets the value of the acctSvcrId property.
     * 
     * @param value
     *     allowed object is
     *     {@link BranchAndFinancialInstitutionIdentification4 }
     *     
     */
    public AccountQueryListV01 setAcctSvcrId(BranchAndFinancialInstitutionIdentification4 value) {
        this.acctSvcrId = value;
        return this;
    }

    /**
     * Gets the value of the org property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the org property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOrg().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Organisation7 }
     * 
     * 
     * @return
     *     The value of the org property.
     */
    public List<Organisation7> getOrg() {
        if (org == null) {
            org = new ArrayList<>();
        }
        return this.org;
    }

    /**
     * Gets the value of the acctSchCrit property.
     * 
     * @return
     *     possible object is
     *     {@link CustomerAccount2 }
     *     
     */
    public CustomerAccount2 getAcctSchCrit() {
        return acctSchCrit;
    }

    /**
     * Sets the value of the acctSchCrit property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomerAccount2 }
     *     
     */
    public AccountQueryListV01 setAcctSchCrit(CustomerAccount2 value) {
        this.acctSchCrit = value;
        return this;
    }

    /**
     * Gets the value of the acctRtrCrit property.
     * 
     * @return
     *     possible object is
     *     {@link CustomerAccountReturnCriteria1 }
     *     
     */
    public CustomerAccountReturnCriteria1 getAcctRtrCrit() {
        return acctRtrCrit;
    }

    /**
     * Sets the value of the acctRtrCrit property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomerAccountReturnCriteria1 }
     *     
     */
    public AccountQueryListV01 setAcctRtrCrit(CustomerAccountReturnCriteria1 value) {
        this.acctRtrCrit = value;
        return this;
    }

    /**
     * Gets the value of the dgtlSgntr property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the dgtlSgntr property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDgtlSgntr().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyAndSignature1 }
     * 
     * 
     * @return
     *     The value of the dgtlSgntr property.
     */
    public List<PartyAndSignature1> getDgtlSgntr() {
        if (dgtlSgntr == null) {
            dgtlSgntr = new ArrayList<>();
        }
        return this.dgtlSgntr;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the org list.
     * @see #getOrg()
     * 
     */
    public AccountQueryListV01 addOrg(Organisation7 org) {
        getOrg().add(org);
        return this;
    }

    /**
     * Adds a new item to the dgtlSgntr list.
     * @see #getDgtlSgntr()
     * 
     */
    public AccountQueryListV01 addDgtlSgntr(PartyAndSignature1 dgtlSgntr) {
        getDgtlSgntr().add(dgtlSgntr);
        return this;
    }

}
