/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDate;

public class LocalDateJsonAdapter
implements JsonSerializer<LocalDate>,
JsonDeserializer<LocalDate> {
    private final Gson gson = new Gson();

    public JsonElement serialize(LocalDate localDate, Type typeOfSrc, JsonSerializationContext context) {
        DateDTO date = new DateDTO();
        date.year = localDate.getYear();
        date.month = localDate.getMonthValue();
        date.day = localDate.getDayOfMonth();
        return this.gson.toJsonTree((Object)date, DateDTO.class);
    }

    public LocalDate deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        DateDTO date = (DateDTO)this.gson.fromJson(jsonElement, DateDTO.class);
        return LocalDate.of((int)date.year, date.month, (int)date.day);
    }

    static class DateDTO {
        Integer year;
        Integer month;
        Integer day;

        DateDTO() {
        }
    }
}

