
package com.prowidesoftware.swift.model.mx.dic;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Structured information supplied to enable the matching, i.e. reconciliation, of a payment with the items that the payment is intended to settle, eg, commercial invoices in an accounts receivable system.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CreditorReferenceInformation1", propOrder = {
    "cdtrRefTp",
    "cdtrRef"
})
public class CreditorReferenceInformation1 {

    @XmlElement(name = "CdtrRefTp")
    protected CreditorReferenceType1 cdtrRefTp;
    @XmlElement(name = "CdtrRef")
    protected String cdtrRef;

    /**
     * Gets the value of the cdtrRefTp property.
     * 
     * @return
     *     possible object is
     *     {@link CreditorReferenceType1 }
     *     
     */
    public CreditorReferenceType1 getCdtrRefTp() {
        return cdtrRefTp;
    }

    /**
     * Sets the value of the cdtrRefTp property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreditorReferenceType1 }
     *     
     */
    public CreditorReferenceInformation1 setCdtrRefTp(CreditorReferenceType1 value) {
        this.cdtrRefTp = value;
        return this;
    }

    /**
     * Gets the value of the cdtrRef property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCdtrRef() {
        return cdtrRef;
    }

    /**
     * Sets the value of the cdtrRef property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public CreditorReferenceInformation1 setCdtrRef(String value) {
        this.cdtrRef = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

}
