/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class NamespaceAndElementFilter
extends XMLFilterImpl {
    private static final transient Logger log = Logger.getLogger(NamespaceAndElementFilter.class.getName());
    private String mainNamespace;
    private boolean inElementToPropagate = false;
    private String localNameToPropagate;
    private boolean inInnerElementToSkip = false;
    private String localNameToSkip;
    private boolean unbindNamespace;

    public NamespaceAndElementFilter(String localName) {
        this(localName, true);
    }

    public NamespaceAndElementFilter(String localName, boolean unbindNamespace) {
        this.localNameToPropagate = localName;
        this.unbindNamespace = unbindNamespace;
    }

    @Override
    public void startElement(String namespace, String localName, String prefix, Attributes attributes) throws SAXException {
        if (this.inInnerElementToSkip) {
            return;
        }
        if (!this.inElementToPropagate && localName.equals(this.localNameToPropagate)) {
            this.inElementToPropagate = true;
            this.mainNamespace = namespace;
        }
        if (this.inElementToPropagate) {
            String namespaceToPropagate = this.resolveNamespaceToPropagate(namespace);
            if (namespaceToPropagate != null) {
                try {
                    super.startElement(namespaceToPropagate, localName, prefix, attributes);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error parsing " + localName + " [" + namespace + "] element", e);
                }
            } else {
                this.inInnerElementToSkip = true;
                this.localNameToSkip = localName;
            }
        }
    }

    private String resolveNamespaceToPropagate(String namespace) {
        if (StringUtils.equals((CharSequence)this.mainNamespace, (CharSequence)namespace)) {
            if (this.unbindNamespace) {
                return "";
            }
            return namespace;
        }
        if (this.isXsysNamespace(namespace)) {
            return namespace;
        }
        return null;
    }

    private boolean isXsysNamespace(String namespace) {
        return "urn:swift:snl:ns.Doc".equals(namespace) || "urn:swift:snl:ns.Sw".equals(namespace) || "urn:swift:snl:ns.SwGbl".equals(namespace) || "urn:swift:snl:ns.SwInt".equals(namespace) || "urn:swift:snl:ns.SwSec".equals(namespace);
    }

    @Override
    public void endElement(String namespace, String localName, String prefix) throws SAXException {
        String namespaceToPropagate;
        if (this.inInnerElementToSkip && localName.equals(this.localNameToSkip)) {
            this.inInnerElementToSkip = false;
            this.localNameToSkip = null;
            return;
        }
        if (this.inElementToPropagate && (namespaceToPropagate = this.resolveNamespaceToPropagate(namespace)) != null) {
            try {
                super.endElement(namespaceToPropagate, localName, prefix);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error parsing " + localName + " [" + namespace + "] element", e);
            }
        }
        if (localName.equals(this.localNameToPropagate)) {
            this.inElementToPropagate = false;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String url) throws SAXException {
        if (this.inElementToPropagate && this.mainNamespace != null && this.isXsysNamespace(url)) {
            try {
                super.startPrefixMapping(prefix, url);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error parsing " + prefix + " [" + url + "] prefix mapping", e);
            }
        }
    }
}

