/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrParser;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.Validate;

public class MxReadImpl
implements MxRead {
    private static final Logger log = Logger.getLogger(MxReadImpl.class.getName());

    public static AbstractMX parse(Class<? extends AbstractMX> targetClass, String xml, Class<?>[] classes) {
        return MxReadImpl.parse(targetClass, xml, classes, new MxReadParams());
    }

    public static AbstractMX parse(Class<? extends AbstractMX> targetClass, String xml, Class<?>[] classes, MxReadParams params) {
        Objects.requireNonNull(targetClass, "target class to parse must not be null");
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(classes, "object model classes array must not be null");
        Objects.requireNonNull(params, "The unmarshalling params cannot be null");
        try {
            SAXSource documentSource = MxParseUtils.createFilteredSAXSource(xml, "Document");
            AbstractMX parsedDocument = (AbstractMX)((Object)MxParseUtils.parseSAXSource(documentSource, targetClass, classes, params));
            Optional<AbstractMX> mx = Optional.ofNullable(parsedDocument);
            Optional<AppHdr> appHdr = AppHdrParser.parse(xml, params);
            if (mx.isPresent() && appHdr.isPresent()) {
                mx.get().setAppHdr(appHdr.get());
            }
            return mx.orElse(null);
        }
        catch (AssertionError e) {
            log.log(Level.SEVERE, "Error parsing XML", (Throwable)((Object)e));
            return null;
        }
        catch (Exception e) {
            MxParseUtils.handleParseException(e);
            return null;
        }
    }

    public static AbstractMX parse(String xml, MxId id) {
        return MxReadImpl.parse(xml, id, new MxReadParams());
    }

    public static AbstractMX parse(String xml, MxId id, MxReadParams params) {
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(params, "unmarshalling params cannot be null");
        MxId resolvedId = id;
        if (id == null) {
            Optional<MxId> detectedIdentifier = MxParseUtils.identifyMessage(xml);
            if (detectedIdentifier.isPresent()) {
                resolvedId = detectedIdentifier.get();
            } else {
                Level level = params.verbose ? Level.SEVERE : Level.FINE;
                log.log(level, "Cannot detect the MX type from the XML, make sure the Document contains a valid namespace or the message contains an identifiable AppHdr");
                return null;
            }
        }
        AbstractMX mx = null;
        String fqn = null;
        try {
            String subPackage = resolvedId.getBusinessProcess() == MxBusinessProcess.xsys ? ".sys" : "";
            fqn = "com.prowidesoftware.swift.model.mx" + subPackage + ".Mx" + resolvedId.camelized();
            Class<?> clazz = Class.forName(fqn);
            Field _classes = clazz.getDeclaredField("_classes");
            mx = MxReadImpl.parse(clazz, xml, (Class[])_classes.get(null), params);
        }
        catch (ClassNotFoundException e) {
            if (params.verbose) {
                log.log(Level.SEVERE, "Cannot find class " + fqn + " to parse the XML", e);
            } else {
                log.fine("MX model implementation not found for " + fqn);
            }
        }
        catch (Exception e) {
            if (params.verbose) {
                log.log(Level.SEVERE, "Error calling parse in specific MX model implementation", e);
            }
            log.fine("Error calling parse in specific MX model implementation");
        }
        return mx;
    }

    @Override
    public AbstractMX read(Class<? extends AbstractMX> targetClass, String xml, Class<?>[] classes) {
        return MxReadImpl.parse(targetClass, xml, classes, new MxReadParams());
    }

    @Override
    public AbstractMX read(String xml, MxId id) {
        return MxReadImpl.parse(xml, id, new MxReadParams());
    }
}

