/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public abstract class AbstractWriter {
    protected Writer writer = null;

    public AbstractWriter(Writer writer) {
        this.writer = writer;
    }

    public AbstractWriter(File file) throws FileNotFoundException {
        this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
    }

    public AbstractWriter(String filename) throws FileNotFoundException {
        this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
    }

    public AbstractWriter(OutputStream stream) {
        this.writer = new BufferedWriter(new OutputStreamWriter(stream));
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }
}

