/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.swift.model.MessageDirection;
import com.prowidesoftware.swift.model.SwiftBlock2Adapter;
import com.prowidesoftware.swift.model.SwiftBlock2Field;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftValueBlock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class SwiftBlock2
extends SwiftValueBlock
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock2.class.getName());
    private static final long serialVersionUID = 7994472954593732477L;
    protected String messagePriority = "N";
    protected String messageType = null;

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Validate.notNull((Object)blockNumber, (String)"parameter 'blockNumber' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockNumber == 2 ? 1 : 0) != 0, (String)"blockNumber must be 2", (Object[])new Object[0]);
    }

    @Override
    protected void setBlockName(String blockName) {
        Validate.notNull((Object)blockName, (String)"parameter 'blockName' cannot be null", (Object[])new Object[0]);
        Validate.isTrue((blockName.compareTo("2") == 0 ? 1 : 0) != 0, (String)"blockName must be string '2'", (Object[])new Object[0]);
    }

    @Override
    public Integer getNumber() {
        return 2;
    }

    @Override
    public String getName() {
        return "2";
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public void setMessagePriority(String messagePriority) {
        this.messagePriority = messagePriority;
    }

    public MessagePriority getMessagePriorityType() {
        if (this.messagePriority != null) {
            try {
                return MessagePriority.valueOf(this.messagePriority);
            }
            catch (Exception e) {
                String text = "Block2 messagePriority contains an invalid value [" + this.messagePriority + "]. The expected values are " + Arrays.toString((Object[])MessagePriority.values());
                log.warning(text);
                log.log(Level.FINEST, text, e);
            }
        }
        return null;
    }

    public boolean isInput() {
        return this instanceof SwiftBlock2Input;
    }

    public boolean isOutput() {
        return this instanceof SwiftBlock2Output;
    }

    public void clean() {
        this.messagePriority = null;
        this.messageType = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwiftBlock2 that = (SwiftBlock2)o;
        return Objects.equals(this.messagePriority, that.messagePriority) && Objects.equals(this.messageType, that.messageType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.messagePriority, this.messageType);
    }

    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(SwiftBlock2.class, (Object)new SwiftBlock2Adapter()).setPrettyPrinting().create();
        return gson.toJson((Object)this, SwiftBlock2.class);
    }

    public String field(SwiftBlock2Field field) {
        switch (field) {
            case Direction: {
                if (this.isInput()) {
                    return MessageDirection.Input.name();
                }
                return MessageDirection.Output.name();
            }
            case MessageType: {
                return this.getMessageType();
            }
            case MessagePriority: {
                return this.getMessagePriority();
            }
        }
        return null;
    }

    public void setField(SwiftBlock2Field field, String value) {
        switch (field) {
            case MessageType: {
                this.setMessageType(value);
                break;
            }
            case MessagePriority: {
                this.setMessagePriority(value);
                break;
            }
        }
    }

    public static enum MessagePriority {
        S("System"),
        N("Normal"),
        U("Urgent");

        private final String label;

        private MessagePriority(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

