/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field62F
extends Field
implements Serializable,
DateContainer,
AmountContainer {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "62F";
    public static final String F_62F = "62F";
    public static final String PARSER_PATTERN = "[c]<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "SESN";
    public static final Integer DC_MARK = 1;
    public static final Integer DATE = 2;
    public static final Integer CURRENCY = 3;
    public static final Integer AMOUNT = 4;

    public Field62F() {
        super(4);
    }

    public Field62F(String value) {
        super(value);
    }

    public Field62F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"62F")) {
            throw new IllegalArgumentException("cannot create field 62F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field62F newInstance(Field62F source) {
        Field62F cp = new Field62F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("62F", value);
    }

    public static Tag emptyTag() {
        return new Tag("62F", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = SwiftParseUtils.getNumericSuffix(value);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(toparse2));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 62F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            ((NumberFormat)f).setMaximumFractionDigits(13);
            Number n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DC><DATE2><3!a><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Date");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "date");
        result.put(3, "currency");
        result.put(4, "amount");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return result;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    public Field62F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field62F setDCMark(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field62F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field62F setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field62F setDate(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field62F setDate(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public Field62F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field62F setCurrency(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field62F setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field62F setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field62F setAmount(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field62F setAmount(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public String getName() {
        return "62F";
    }

    public static Field62F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("62F");
        if (t == null) {
            return null;
        }
        return new Field62F(t);
    }

    public static Field62F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field62F.get(msg.getBlock4());
    }

    public static List<Field62F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field62F.getAll(msg.getBlock4());
    }

    public static List<Field62F> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("62F");
        if (arr != null && arr.length > 0) {
            ArrayList<Field62F> result = new ArrayList<Field62F>(arr.length);
            for (Tag f : arr) {
                result.add(new Field62F(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static Field62F fromJson(String json) {
        Field62F field = new Field62F();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent4(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

