/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field71N
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "71N";
    public static final String F_71N = "71N";
    public static final String PARSER_PATTERN = "S[$S]0-6";
    public static final String COMPONENTS_PATTERN = "SSSSSSS";
    public static final Integer NARRATIVE = 1;

    public Field71N() {
        super(7);
    }

    public Field71N(String value) {
        super(value);
    }

    public Field71N(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"71N")) {
            throw new IllegalArgumentException("cannot create field 71N from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field71N newInstance(Field71N source) {
        Field71N cp = new Field71N();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("71N", value);
    }

    public static Tag emptyTag() {
        return new Tag("71N", "");
    }

    @Override
    public void parse(String value) {
        this.init(7);
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, null, 0, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 7);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 7) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 71N");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        if (component == 7) {
            return this.getComponent(7);
        }
        return null;
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "4!c[$35z]0-6";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 7;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        result.add("Narrative 5");
        result.add("Narrative 6");
        result.add("Narrative 7");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "narrative");
        result.put(2, "narrative2");
        result.put(3, "narrative3");
        result.put(4, "narrative4");
        result.put(5, "narrative5");
        result.put(6, "narrative6");
        result.put(7, "narrative7");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getNarrativeLine1() {
        return this.getComponent(1);
    }

    public String getNarrativeLine2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine3() {
        return this.getComponent(3);
    }

    public String getNarrativeLine4() {
        return this.getComponent(4);
    }

    public String getNarrativeLine5() {
        return this.getComponent(5);
    }

    public String getNarrativeLine6() {
        return this.getComponent(6);
    }

    public String getNarrativeLine7() {
        return this.getComponent(7);
    }

    public String getNarrative() {
        return this.getNarrative(null);
    }

    public String getNarrative(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < 8; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public Field71N setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field71N setNarrativeLine1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field71N setNarrativeLine2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field71N setNarrativeLine3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field71N setNarrativeLine4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field71N setNarrativeLine5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field71N setNarrativeLine6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field71N setNarrativeLine7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    public Field71N setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, 7, 0, lines);
        return this;
    }

    public Field71N setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field71N setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field71N setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field71N setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field71N setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field71N setComponent7(String component7) {
        this.setComponent(7, component7);
        return this;
    }

    @Override
    public String getName() {
        return "71N";
    }

    public static Field71N get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("71N");
        if (t == null) {
            return null;
        }
        return new Field71N(t);
    }

    public static Field71N get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field71N.get(msg.getBlock4());
    }

    public static List<Field71N> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field71N.getAll(msg.getBlock4());
    }

    public static List<Field71N> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("71N");
        if (arr != null && arr.length > 0) {
            ArrayList<Field71N> result = new ArrayList<Field71N>(arr.length);
            for (Tag f : arr) {
                result.add(new Field71N(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field71N cp = Field71N.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field71N cp = Field71N.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field71N cp = Field71N.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field71N fromJson(String json) {
        Field71N field = new Field71N();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("narrative") != null) {
            field.setComponent1(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent2(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent3(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent4(jsonObject.get("narrative4").getAsString());
        }
        if (jsonObject.get("narrative5") != null) {
            field.setComponent5(jsonObject.get("narrative5").getAsString());
        }
        if (jsonObject.get("narrative6") != null) {
            field.setComponent6(jsonObject.get("narrative6").getAsString());
        }
        if (jsonObject.get("narrative7") != null) {
            field.setComponent7(jsonObject.get("narrative7").getAsString());
        }
        return field;
    }
}

