/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StructuredNarrative {
    private String codeword;
    private String currency;
    private BigDecimal amount;
    private String country;
    private final List<String> narrativeFragments = new ArrayList<String>();
    private final List<String> narrativeSupplementFragments = new ArrayList<String>();

    public String getCodeword() {
        return this.codeword;
    }

    StructuredNarrative setCodeword(String codeword) {
        this.codeword = codeword;
        return this;
    }

    public String getCurrency() {
        return this.currency;
    }

    StructuredNarrative setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    StructuredNarrative setAmount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public String getCountry() {
        return this.country;
    }

    StructuredNarrative setCountry(String country) {
        this.country = country;
        return this;
    }

    public List<String> getNarrativeFragments() {
        return this.narrativeFragments;
    }

    StructuredNarrative addNarrativeFragment(String narrativeFragment) {
        this.narrativeFragments.add(narrativeFragment);
        return this;
    }

    public List<String> getNarrativeSupplementFragments() {
        return this.narrativeSupplementFragments;
    }

    StructuredNarrative addNarrativeSupplementFragment(String narrativeSupplementFragment) {
        this.narrativeSupplementFragments.add(narrativeSupplementFragment);
        return this;
    }

    public String getNarrative() {
        return this.getNarrative(null);
    }

    public String getNarrative(String delimiter) {
        if (!this.narrativeFragments.isEmpty()) {
            String s = delimiter != null ? delimiter : "";
            return String.join((CharSequence)s, this.narrativeFragments);
        }
        return null;
    }

    public String getNarrativeSupplement() {
        return this.getNarrativeSupplement(null);
    }

    public String getNarrativeSupplement(String delimiter) {
        if (!this.narrativeSupplementFragments.isEmpty()) {
            String s = delimiter != null ? delimiter : "";
            return String.join((CharSequence)s, this.narrativeSupplementFragments);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.codeword == null && this.currency == null && this.amount == null && this.country == null && this.narrativeFragments.isEmpty() && this.narrativeSupplementFragments.isEmpty();
    }

    public boolean valid() {
        return StringUtils.isNotBlank((CharSequence)this.codeword) && (this.currency != null && this.amount != null || this.country != null || !this.narrativeFragments.isEmpty());
    }
}

