/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field103;
import com.prowidesoftware.swift.model.field.Field106;
import com.prowidesoftware.swift.model.field.Field177;
import com.prowidesoftware.swift.model.field.Field202;
import com.prowidesoftware.swift.model.field.Field203;
import com.prowidesoftware.swift.model.field.Field343;
import com.prowidesoftware.swift.model.field.Field533;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT029
extends AbstractMT
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT029.class.getName());
    public static final String NAME = "029";

    public MT029(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT029(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT029 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT029(m);
    }

    public MT029() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT029(String sender, String receiver) {
        super(29, sender, receiver);
    }

    public MT029(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT029.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT029 object from FIN content with a Service Message. Check if the MT029 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT029 object from FIN content with message type " + param.getType());
        }
    }

    public static MT029 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT029(fin);
    }

    public MT029(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT029 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT029(stream);
    }

    public MT029(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT029 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT029(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT029 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT029 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT029 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT029 fromJson(String json) {
        return (MT029)AbstractMT.fromJson(json);
    }

    public Field202 getField202() {
        Tag t = this.tag("202");
        if (t != null) {
            return new Field202(t.getValue());
        }
        return null;
    }

    public Field203 getField203() {
        Tag t = this.tag("203");
        if (t != null) {
            return new Field203(t.getValue());
        }
        return null;
    }

    public Field103 getField103() {
        Tag t = this.tag("103");
        if (t != null) {
            return new Field103(t.getValue());
        }
        return null;
    }

    public Field343 getField343() {
        Tag t = this.tag("343");
        if (t != null) {
            return new Field343(t.getValue());
        }
        return null;
    }

    public Field533 getField533() {
        Tag t = this.tag("533");
        if (t != null) {
            return new Field533(t.getValue());
        }
        return null;
    }

    public List<Field177> getField177() {
        ArrayList<Field177> result = new ArrayList<Field177>();
        Tag[] tags = this.tags("177");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field177(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field106> getField106() {
        ArrayList<Field106> result = new ArrayList<Field106>();
        Tag[] tags = this.tags("106");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field106(tag.getValue()));
            }
        }
        return result;
    }
}

