/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field116;
import com.prowidesoftware.swift.model.field.Field118;
import com.prowidesoftware.swift.model.field.Field202;
import com.prowidesoftware.swift.model.field.Field203;
import com.prowidesoftware.swift.model.field.Field206;
import com.prowidesoftware.swift.model.field.Field208;
import com.prowidesoftware.swift.model.field.Field305;
import com.prowidesoftware.swift.model.field.Field337;
import com.prowidesoftware.swift.model.field.Field338;
import com.prowidesoftware.swift.model.field.Field348;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT061
extends AbstractMT
implements Serializable {
    public static final int SRU = 2020;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT061.class.getName());
    public static final String NAME = "061";

    public MT061(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT061(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT061 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT061(m);
    }

    public MT061() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT061(String sender, String receiver) {
        super(61, sender, receiver);
    }

    public MT061(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT061.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT061 object from FIN content with a Service Message. Check if the MT061 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT061 object from FIN content with message type " + param.getType());
        }
    }

    public static MT061 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT061(fin);
    }

    public MT061(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT061 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT061(stream);
    }

    public MT061(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT061 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT061(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT061 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT061 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT061 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static final MT061 fromJson(String json) {
        return (MT061)AbstractMT.fromJson(json);
    }

    public Field202 getField202() {
        Tag t = this.tag("202");
        if (t != null) {
            return new Field202(t.getValue());
        }
        return null;
    }

    public Field203 getField203() {
        Tag t = this.tag("203");
        if (t != null) {
            return new Field203(t.getValue());
        }
        return null;
    }

    public Field206 getField206() {
        Tag t = this.tag("206");
        if (t != null) {
            return new Field206(t.getValue());
        }
        return null;
    }

    public Field348 getField348() {
        Tag t = this.tag("348");
        if (t != null) {
            return new Field348(t.getValue());
        }
        return null;
    }

    public Field305 getField305() {
        Tag t = this.tag("305");
        if (t != null) {
            return new Field305(t.getValue());
        }
        return null;
    }

    public Field337 getField337() {
        Tag t = this.tag("337");
        if (t != null) {
            return new Field337(t.getValue());
        }
        return null;
    }

    public Field208 getField208() {
        Tag t = this.tag("208");
        if (t != null) {
            return new Field208(t.getValue());
        }
        return null;
    }

    public Field338 getField338() {
        Tag t = this.tag("338");
        if (t != null) {
            return new Field338(t.getValue());
        }
        return null;
    }

    public Field116 getField116() {
        Tag t = this.tag("116");
        if (t != null) {
            return new Field116(t.getValue());
        }
        return null;
    }

    public Field118 getField118() {
        Tag t = this.tag("118");
        if (t != null) {
            return new Field118(t.getValue());
        }
        return null;
    }
}

